/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Cloner<T> {
    public abstract T clone(T var1) throws CloneNotSupportedException;

    public static <T> Cloner<T> createBasicReflectionCloner(Class<T> clazz) throws CloneNotSupportedException {
        return new BasicReflectionCloner(clazz);
    }

    private static class BasicReflectionCloner<T>
    extends Cloner<T> {
        private final Constructor<T> constructor;
        private final Set<Field> fields;

        private BasicReflectionCloner(Class<T> clazz) throws CloneNotSupportedException {
            try {
                this.constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw new CloneNotSupportedException("Instances of the given class cannot be cloned by this cloner.");
            }
            this.constructor.setAccessible(true);
            HashSet<Field> fieldsLocal = new HashSet<Field>();
            for (Field field : BasicReflectionCloner.getFields(clazz)) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldsLocal.add(field);
            }
            this.fields = Collections.unmodifiableSet(fieldsLocal);
        }

        private static Field[] getFields(Class<?> clazz) {
            HashSet<Field> fields = new HashSet<Field>();
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            if (!clazz.getSuperclass().getName().equals("java.lang.Object")) {
                fields.addAll(Arrays.asList(BasicReflectionCloner.getFields(clazz.getSuperclass())));
            }
            return fields.toArray(new Field[fields.size()]);
        }

        @Override
        public T clone(T original) throws CloneNotSupportedException {
            try {
                T clone = this.constructor.newInstance(new Object[0]);
                for (Field field : this.fields) {
                    Object object = field.get(original);
                    try {
                        object = object.getClass().getDeclaredMethod("clone", new Class[0]).invoke(object, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    field.set(clone, object);
                }
                return clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException("The given object cannot be cloned.");
            }
        }
    }
}

