/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts.io;

import de.robingrether.mcts.MinecraftTrainSimulator;
import de.robingrether.util.ObjectUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class UpdateCheck
implements Runnable {
    public static final int PROJECT_ID = 64141;
    public static final String API_URL = "https://api.curseforge.com/servermods/files?projectIds=";
    public static final String API_CHECKSUM = "md5";
    public static final String API_DOWNLOAD_URL = "downloadUrl";
    public static final String API_FILE_NAME = "fileName";
    public static final String API_GAME_VERSION = "gameVersion";
    public static final String API_NAME = "name";
    public static final String API_RELEASE_TYPE = "releaseType";
    private MinecraftTrainSimulator plugin;
    private String pluginVersion;
    private String latestVersion;
    private CommandSender toBeNotified;
    private String downloadUrl;
    private String checksum;
    private boolean autoDownload;

    public UpdateCheck(MinecraftTrainSimulator plugin, CommandSender toBeNotified, boolean autoDownload) {
        this.plugin = plugin;
        this.pluginVersion = plugin.getFullName();
        this.toBeNotified = toBeNotified;
        this.autoDownload = autoDownload;
    }

    @Override
    public void run() {
        this.checkForUpdate();
        if (this.isUpdateAvailable()) {
            this.toBeNotified.sendMessage(ChatColor.GOLD + "[MCTS] An update is available: " + this.latestVersion);
            if (this.autoDownload) {
                this.downloadUpdate();
            } else {
                this.toBeNotified.sendMessage(ChatColor.GOLD + "[MCTS] You can enable automatic updates in the config file.");
            }
        }
    }

    private boolean isUpdateAvailable() {
        if (this.latestVersion != null && !this.pluginVersion.equals(this.latestVersion)) {
            try {
                int current = Integer.parseInt(this.pluginVersion.split(" |-")[1].replace(".", "")) - (this.pluginVersion.endsWith("-SNAPSHOT") ? 1 : 0);
                int latest = Integer.parseInt(this.latestVersion.split(" ")[1].replace(".", ""));
                return latest > current;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return false;
    }

    private void checkForUpdate() {
        block12: {
            BufferedReader reader = null;
            try {
                try {
                    URL url = new URL("https://api.curseforge.com/servermods/files?projectIds=64141");
                    URLConnection connection = url.openConnection();
                    connection.addRequestProperty("User-Agent", String.valueOf(this.pluginVersion.replace(' ', '/')) + " (by RobinGrether)");
                    connection.setDoOutput(true);
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String response = reader.readLine();
                    JSONArray array = (JSONArray)JSONValue.parse((String)response);
                    this.latestVersion = null;
                    JSONObject object = (JSONObject)array.get(array.size() - 1);
                    this.latestVersion = (String)object.get((Object)API_NAME);
                    this.downloadUrl = (String)object.get((Object)API_DOWNLOAD_URL);
                    this.checksum = (String)object.get((Object)API_CHECKSUM);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Update checking failed: " + e.getClass().getSimpleName());
                    if (reader == null) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadUpdate() {
        File oldFile = this.plugin.getPluginFile();
        File newFile = new File(this.plugin.getServer().getUpdateFolderFile(), oldFile.getName());
        if (newFile.exists()) {
            this.toBeNotified.sendMessage(ChatColor.GOLD + "[MCTS] Update already downloaded. (Restart server to apply update)");
            return;
        }
        InputStream input = null;
        OutputStream output = null;
        try {
            URL url = new URL(this.downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", String.valueOf(this.pluginVersion.replace(' ', '/')) + " (by RobinGrether)");
            connection.setDoOutput(true);
            if (ObjectUtil.equals(connection.getResponseCode(), 301, 302)) {
                this.downloadUrl = connection.getHeaderField("Location");
                this.downloadUpdate();
                return;
            }
            if (connection.getResponseCode() != 200) {
                this.toBeNotified.sendMessage(ChatColor.RED + "[MCTS] Download failed.");
                this.plugin.getLogger().log(Level.WARNING, "Update download failed: HTTP error");
                return;
            }
            this.toBeNotified.sendMessage(ChatColor.GOLD + "[MCTS] Downloading update...");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            input = new DigestInputStream(connection.getInputStream(), messageDigest);
            this.plugin.getServer().getUpdateFolderFile().mkdir();
            output = new FileOutputStream(newFile);
            byte[] data = new byte[4096];
            while (true) {
                int fetched;
                if ((fetched = input.read(data)) <= 0) {
                    input.close();
                    output.close();
                    if (!DatatypeConverter.printHexBinary((byte[])messageDigest.digest()).toLowerCase(Locale.ENGLISH).equals(this.checksum.toLowerCase(Locale.ENGLISH))) break;
                    this.toBeNotified.sendMessage(ChatColor.GOLD + "[MCTS] Download succeeded. (Restart server to apply update)");
                    return;
                }
                output.write(data, 0, fetched);
            }
            newFile.delete();
            this.toBeNotified.sendMessage(ChatColor.RED + "[MCTS] Download failed.");
            this.plugin.getLogger().log(Level.WARNING, "Update download failed: checksum is bad");
            return;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.toBeNotified.sendMessage(ChatColor.RED + "[MCTS] Download failed.");
            this.plugin.getLogger().log(Level.WARNING, "Update download failed: " + e.getClass().getSimpleName());
            return;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

