/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import com.bergerkiller.bukkit.tc.controller.MinecartMember;
import com.bergerkiller.bukkit.tc.controller.MinecartMemberStore;
import com.bergerkiller.bukkit.tc.controller.type.MinecartMemberFurnace;
import de.robingrether.mcts.Train;
import org.bukkit.entity.Minecart;
import org.bukkit.scheduler.BukkitRunnable;

public class Accelerator
extends BukkitRunnable {
    private Train train;
    private double targetVelocity;
    private int amplifier;
    private int furnaceCarts = 0;

    public Accelerator(Train train, double targetVelocity, int amplifier) {
        this.train = train;
        this.targetVelocity = targetVelocity;
        this.amplifier = amplifier;
        for (MinecartMember minecart : train.getMinecarts()) {
            if (minecart instanceof MinecartMemberFurnace) {
                ++this.furnaceCarts;
            }
            if (this.furnaceCarts == 4) break;
        }
    }

    public double getTargetVelocity() {
        return this.targetVelocity;
    }

    public void run() {
        MinecartGroup minecarts = this.train.getMinecarts();
        if (minecarts.isEmpty()) {
            this.train.terminate();
            return;
        }
        double force = minecarts.getAverageForce();
        if (this.targetVelocity == 0.0) {
            if (force > 0.0) {
                if ((force -= 5.0E-4 * (double)this.amplifier) < 0.0) {
                    force = 0.0;
                }
            } else if (force < 0.0 && (force += 5.0E-4 * (double)this.amplifier) > 0.0) {
                force = 0.0;
            }
        } else {
            double targetVelocitySigned;
            if (!(this.train.getLeader().getVehicle() instanceof Minecart)) {
                return;
            }
            if (!this.train.hasFuel()) {
                return;
            }
            boolean facingForward = minecarts.head().equals(MinecartMemberStore.convert((Minecart)((Minecart)this.train.getLeader().getVehicle())));
            if ((force *= facingForward ? 1.0 : -1.0) < (targetVelocitySigned = this.targetVelocity * (double)this.train.getDirection())) {
                if ((force += this.targetVelocity * 0.02 * (double)this.furnaceCarts) > targetVelocitySigned) {
                    force = targetVelocitySigned;
                }
            } else if (force > targetVelocitySigned && (force -= this.targetVelocity * 0.02 * (double)this.furnaceCarts) < targetVelocitySigned) {
                force = targetVelocitySigned;
            }
            force *= facingForward ? 1.0 : -1.0;
            this.train.consumeFuel();
        }
        minecarts.setForwardForce(force);
    }
}

