/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.common.entity.type.CommonMinecart;
import com.bergerkiller.bukkit.tc.CollisionMode;
import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import com.bergerkiller.bukkit.tc.controller.MinecartMember;
import com.bergerkiller.bukkit.tc.controller.MinecartMemberStore;
import com.bergerkiller.bukkit.tc.properties.TrainProperties;
import de.robingrether.mcts.Accelerator;
import de.robingrether.mcts.MinecraftTrainSimulator;
import de.robingrether.mcts.render.TrainMapRenderer;
import org.bukkit.Effect;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public abstract class Train {
    protected MinecartGroup minecarts;
    private Player leader;
    private int direction;
    private Accelerator accelerator;
    protected int status;
    private MapView controlPanel;
    private double maxSpeed = 100.0;

    protected Train(MinecartGroup minecarts, MapView controlPanel) {
        this.minecarts = minecarts;
        this.leader = null;
        this.direction = 0;
        this.accelerator = null;
        this.status = 0;
        this.controlPanel = controlPanel;
        this.initTrainProperties();
        this.initMap();
    }

    public MinecartGroup getMinecarts() {
        return this.minecarts;
    }

    public abstract boolean addFuel(int var1);

    public abstract int getFuel();

    public Player getLeader() {
        return this.leader;
    }

    public boolean setLeader(Player player) {
        if (player.getVehicle() instanceof Minecart) {
            MinecartMember minecart = MinecartMemberStore.convert((Minecart)((Minecart)player.getVehicle()));
            if (this.minecarts.head().equals(minecart)) {
                this.leader = player;
                return true;
            }
            if (this.minecarts.tail().equals(minecart)) {
                this.leader = player;
                return true;
            }
        }
        return false;
    }

    public boolean canLead(Player player) {
        if (player.getVehicle() instanceof Minecart) {
            MinecartMember minecart = MinecartMemberStore.convert((Minecart)((Minecart)player.getVehicle()));
            if (this.minecarts.head().equals(minecart) || this.minecarts.tail().equals(minecart)) {
                return true;
            }
        }
        return false;
    }

    public boolean isLeader(Player player) {
        if (this.leader == null) {
            return false;
        }
        return this.leader.equals(player);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction, boolean playEffect) {
        if (this.direction != direction) {
            this.direction = direction;
            if (this.leader != null && playEffect) {
                this.leader.getWorld().playEffect(this.leader.getLocation(), Effect.DOOR_TOGGLE, 0);
            }
        }
    }

    public int getCombinedLever() {
        return this.status;
    }

    public void setCombinedLever(int status, boolean playEffect) {
        if (this.status == status) {
            return;
        }
        this.terminate();
        if (status > 0) {
            this.accelerator = new Accelerator(this, this.getSpeedLimit() * (double)status / 4.0, status);
            if (this.leader != null && playEffect) {
                this.leader.getWorld().playEffect(this.leader.getLocation(), Effect.DOOR_TOGGLE, 0);
            }
            this.accelerator.runTaskTimer((Plugin)MinecraftTrainSimulator.getInstance(), 1L, 1L);
        } else if (status < 0) {
            this.accelerator = new Accelerator(this, 0.0, -status);
            if (this.leader != null && playEffect) {
                this.leader.getWorld().playEffect(this.leader.getLocation(), Effect.DOOR_TOGGLE, 0);
            }
            this.accelerator.runTaskTimer((Plugin)MinecraftTrainSimulator.getInstance(), 1L, 1L);
        }
        this.status = status;
    }

    public abstract boolean consumeFuel();

    public abstract boolean hasFuel();

    public double getSpeedLimit() {
        return this.maxSpeed;
    }

    public boolean isAccelerating() {
        return this.accelerator.getTargetVelocity() != 0.0 && this.hasFuel();
    }

    public void terminate() {
        if (this.accelerator != null) {
            this.accelerator.cancel();
        }
    }

    public short getMapId() {
        return this.controlPanel.getId();
    }

    private void initTrainProperties() {
        TrainProperties properties = this.minecarts.getProperties();
        properties.playerCollision = CollisionMode.PUSH;
        properties.miscCollision = CollisionMode.PUSH;
        properties.trainCollision = CollisionMode.PUSH;
        for (MinecartMember minecart : this.minecarts) {
            double maxSpeed = ((CommonMinecart)minecart.getEntity()).getMaxSpeed();
            if (!(maxSpeed < this.maxSpeed)) continue;
            this.maxSpeed = maxSpeed;
        }
    }

    private void initMap() {
        for (MapRenderer renderer : this.controlPanel.getRenderers()) {
            this.controlPanel.removeRenderer(renderer);
        }
        this.controlPanel.addRenderer((MapRenderer)new TrainMapRenderer(this));
    }
}

