/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.util;

import de.robingrether.util.StringOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class StringUtil {
    public static boolean contains(String string, String ... strings) {
        for (String s : strings) {
            if (!string.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(String string, String ... strings) {
        for (String s : strings) {
            if (!string.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String string, String ... strings) {
        for (String s : strings) {
            if (!string.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static String join(char seperator, String ... strings) {
        return StringUtil.join(String.valueOf(seperator), strings);
    }

    public static String join(String seperator, String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            builder.append(seperator);
            builder.append(strings[i]);
        }
        return builder.toString();
    }

    public static String capitalize(String string) {
        String[] words = string.split(" ", -1);
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() <= 0) continue;
            words[i] = Character.toString(words[i].charAt(0)).toUpperCase(Locale.ENGLISH) + words[i].substring(1);
        }
        return StringUtil.join(' ', words);
    }

    public static String capitalizeFully(String string) {
        String[] words = string.split(" ", -1);
        for (int i = 0; i < words.length; ++i) {
            if (words[i].length() <= 0) continue;
            words[i] = Character.toString(words[i].charAt(0)).toUpperCase(Locale.ENGLISH) + words[i].substring(1).toLowerCase(Locale.ENGLISH);
        }
        return StringUtil.join(' ', words);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isNotBlank(String string) {
        return string != null && !string.isEmpty() && !string.trim().isEmpty();
    }

    public static String readFrom(InputStream input) {
        try {
            int read;
            StringOutputStream output = new StringOutputStream();
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
            output.close();
            return output.toString();
        }
        catch (IOException e) {
            return "";
        }
    }
}

