/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts.render;

import de.robingrether.mcts.ElectricTrain;
import de.robingrether.mcts.Train;
import de.robingrether.mcts.render.Images;
import de.robingrether.mcts.render.UnitOfSpeed;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class TrainMapRenderer
extends MapRenderer {
    private static final NumberFormat signedFormat = new DecimalFormat("+#;-#");
    private static final NumberFormat speedFormat = new DecimalFormat("##0.0 ");
    public static UnitOfSpeed unitOfSpeed = UnitOfSpeed.KILOMETRES_PER_HOUR;
    private Train train;

    public TrainMapRenderer(Train train) {
        this.train = train;
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        if (this.train == null) {
            return;
        }
        if (this.train.getMinecarts() == null || this.train.getMinecarts().size() == 0) {
            return;
        }
        try {
            canvas.drawImage(0, 0, Images.getImage(0));
            canvas.drawImage(4, 19, Images.getImage((this.train instanceof ElectricTrain ? 3 : 1) + (this.train.isAccelerating() ? 1 : 0)));
            canvas.drawText(123 - MinecraftFont.Font.getWidth("Speed"), 51, (MapFont)MinecraftFont.Font, "\u00a716;Speed");
            String text = String.valueOf(speedFormat.format(unitOfSpeed.convert(this.train.getMinecarts().getAverageForce()))) + unitOfSpeed.getSymbol();
            canvas.drawText(123 - MinecraftFont.Font.getWidth(text), 61, (MapFont)MinecraftFont.Font, text);
            canvas.drawText(123 - MinecraftFont.Font.getWidth("Height"), 25, (MapFont)MinecraftFont.Font, "\u00a716;Height");
            text = Integer.toString(this.train.getMinecarts().head().getBlock(0, -1, 0).getY());
            canvas.drawText(123 - MinecraftFont.Font.getWidth(text), 35, (MapFont)MinecraftFont.Font, text);
            canvas.drawText(123 - MinecraftFont.Font.getWidth("Fuel"), 77, (MapFont)MinecraftFont.Font, "\u00a716;Fuel");
            text = this.train instanceof ElectricTrain ? (this.train.hasFuel() ? "yes" : "no") : Integer.toString(this.train.getFuel());
            canvas.drawText(123 - MinecraftFont.Font.getWidth(text), 87, (MapFont)MinecraftFont.Font, text);
            canvas.drawText(5, 51, (MapFont)MinecraftFont.Font, "\u00a716;Direction");
            canvas.drawText(5, 61, (MapFont)MinecraftFont.Font, signedFormat.format(this.train.getDirection()));
            canvas.drawText(5, 77, (MapFont)MinecraftFont.Font, "\u00a716;Lever");
            canvas.drawText(5, 87, (MapFont)MinecraftFont.Font, signedFormat.format(this.train.getCombinedLever()));
            canvas.drawText(5, 103, (MapFont)MinecraftFont.Font, "\u00a716;Name");
            canvas.drawText(5, 113, (MapFont)MinecraftFont.Font, this.train.getMinecarts().getProperties().getDisplayName());
        }
        catch (NullPointerException e) {
            return;
        }
    }
}

