/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import de.robingrether.mcts.MinecraftTrainSimulator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;

public class Substation {
    private final Location[] blocks = new Location[9];
    private final String name;
    private final int voltage;
    private boolean created = false;
    private boolean redstone = false;
    private boolean state = false;
    private static Pattern pattern = Pattern.compile("^(.+) ([0-9]+) \\((off|on)\\) - (.+) \\((-?[0-9]+), (-?[0-9]+), (-?[0-9]+)\\), \\((-?[0-9]+), (-?[0-9]+), (-?[0-9]+)\\)");

    public Substation(String name, int voltage) {
        if (voltage < 1) {
            throw new IllegalArgumentException("Voltage may not be 0 or less!");
        }
        this.name = name;
        this.voltage = voltage;
    }

    public void turnOn() {
        this.state = true;
        MinecraftTrainSimulator.getInstance().updateCatenary();
    }

    public void turnOff() {
        this.state = false;
        MinecraftTrainSimulator.getInstance().updateCatenary();
    }

    public boolean isTurnedOn() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public int getVoltage() {
        return this.voltage;
    }

    public boolean isRedstoneBlockPlaced() {
        return this.redstone;
    }

    public boolean placeRedstoneBlock(Location location) {
        if (this.created || this.redstone) {
            return false;
        }
        this.blocks[0] = location.clone();
        this.blocks[1] = location.clone().add(0.0, 1.0, 0.0);
        this.blocks[2] = location.clone().add(0.0, 2.0, 0.0);
        this.redstone = true;
        return true;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isAt(Location location) {
        for (Location block : this.blocks) {
            if (!block.equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeverAt(Location location) {
        return this.blocks[2].equals((Object)location);
    }

    public Location getRedstoneBlockLocation() {
        return this.blocks[0].clone();
    }

    public Location getIronFenceLocation() {
        return this.blocks[7].clone();
    }

    public boolean placeFence(Location location) {
        if (this.created || !this.redstone) {
            return false;
        }
        this.blocks[3] = location.clone();
        this.blocks[4] = location.clone().add(0.0, 1.0, 0.0);
        this.blocks[5] = location.clone().add(0.0, 2.0, 0.0);
        this.blocks[6] = location.clone().add(0.0, 3.0, 0.0);
        this.blocks[7] = location.clone().add((double)(this.blocks[3].getBlockX() - this.blocks[0].getBlockX()), 2.0, (double)(this.blocks[3].getBlockZ() - this.blocks[0].getBlockZ()));
        this.blocks[8] = location.clone().add((double)(this.blocks[3].getBlockX() - this.blocks[0].getBlockX()), 3.0, (double)(this.blocks[3].getBlockZ() - this.blocks[0].getBlockZ()));
        this.blocks[1].getBlock().setType(Material.IRON_BLOCK);
        this.blocks[2].getBlock().setType(Material.LEVER);
        this.blocks[2].getBlock().setData((byte)5);
        Material fence = this.blocks[3].getBlock().getType();
        this.blocks[4].getBlock().setType(fence);
        this.blocks[5].getBlock().setType(fence);
        this.blocks[6].getBlock().setType(fence);
        this.blocks[7].getBlock().setType(Material.IRON_FENCE);
        this.blocks[8].getBlock().setType(fence);
        this.created = true;
        return true;
    }

    public boolean delete() {
        if (!this.created) {
            return false;
        }
        this.blocks[2].getBlock().setType(Material.AIR);
        this.blocks[1].getBlock().setType(Material.AIR);
        this.blocks[4].getBlock().setType(Material.AIR);
        this.blocks[5].getBlock().setType(Material.AIR);
        this.blocks[6].getBlock().setType(Material.AIR);
        this.blocks[7].getBlock().setType(Material.AIR);
        this.blocks[8].getBlock().setType(Material.AIR);
        return true;
    }

    public String getLocationString() {
        if (this.created) {
            return String.format("%s (%s, %s, %s)", this.blocks[0].getWorld().getName(), this.blocks[0].getBlockX(), this.blocks[0].getBlockY(), this.blocks[0].getBlockZ());
        }
        return "no position, still in creation";
    }

    public String toString() {
        return String.format("%s %s (%s) - %s (%s, %s, %s), (%s, %s, %s)", this.name, this.voltage, this.isTurnedOn() ? "on" : "off", this.blocks[0].getWorld().getName(), this.blocks[0].getBlockX(), this.blocks[0].getBlockY(), this.blocks[0].getBlockZ(), this.blocks[3].getBlockX(), this.blocks[3].getBlockY(), this.blocks[3].getBlockZ());
    }

    public static Substation fromString(String source) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.matches()) {
            Substation substation = new Substation(matcher.group(1), Integer.parseInt(matcher.group(2)));
            World world = Bukkit.getWorld((String)matcher.group(4));
            if (world == null) {
                return null;
            }
            substation.placeRedstoneBlock(new Location(world, (double)Integer.parseInt(matcher.group(5)), (double)Integer.parseInt(matcher.group(6)), (double)Integer.parseInt(matcher.group(7))));
            substation.placeFence(new Location(world, (double)Integer.parseInt(matcher.group(8)), (double)Integer.parseInt(matcher.group(9)), (double)Integer.parseInt(matcher.group(10))));
            switch (matcher.group(3)) {
                case "on": {
                    substation.turnOn();
                    substation.blocks[2].getBlock().setData((byte)13);
                    break;
                }
                case "off": {
                    substation.turnOff();
                }
            }
            return substation;
        }
        return null;
    }
}

