/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import de.robingrether.mcts.Train;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.map.MapView;

public class SteamTrain
extends Train {
    private int fuel = 0;
    private static final HashSet<Material> fuels = new HashSet();

    public SteamTrain(MinecartGroup minecarts, MapView controlPanel) {
        super(minecarts, controlPanel);
    }

    @Override
    public boolean addFuel(int fuel) {
        if (fuel > 0) {
            this.fuel += fuel;
            return true;
        }
        return false;
    }

    @Override
    public int getFuel() {
        return this.fuel;
    }

    @Override
    public boolean consumeFuel() {
        this.fuel -= this.status;
        if (this.fuel < 0) {
            this.fuel = 0;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasFuel() {
        return this.fuel - this.status >= 0;
    }

    public static boolean isFuel(Material material) {
        return fuels.contains(material);
    }

    public static boolean newFuel(Material material) {
        return fuels.add(material);
    }

    static {
        SteamTrain.newFuel(Material.COAL);
    }
}

