/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts.render;

import de.robingrether.mcts.ElectricTrain;
import de.robingrether.mcts.Train;
import de.robingrether.mcts.render.Images;
import de.robingrether.mcts.render.UnitOfSpeed;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class TrainMapRenderer
extends MapRenderer {
    private static final NumberFormat signedFormat = new DecimalFormat("+#;-#");
    private static final NumberFormat speedFormat = new DecimalFormat("##0.0 ");
    public static UnitOfSpeed unitOfSpeed = UnitOfSpeed.KILOMETRES_PER_HOUR;
    private Train train;

    public TrainMapRenderer(Train train) {
        this.train = train;
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        if (this.train == null) {
            return;
        }
        if (this.train.getMinecarts() == null || this.train.getMinecarts().size() == 0) {
            return;
        }
        try {
            canvas.drawImage(0, 0, Images.getImage(1));
            canvas.drawImage(4, 19, Images.getImage((this.train instanceof ElectricTrain ? 4 : 2) + (this.train.isAccelerating() ? 1 : 0)));
            canvas.drawImage(0, 96, Images.getImage(0));
            canvas.drawText(100, 20, (MapFont)MinecraftFont.Font, String.valueOf(speedFormat.format(unitOfSpeed.convert(this.train.getMinecarts().getAverageForce()))) + unitOfSpeed.getSymbol());
            canvas.drawText(100, 35, (MapFont)MinecraftFont.Font, Integer.toString(this.train.getMinecarts().head().getBlock(0, -1, 0).getY()));
            canvas.drawText(82, 50, (MapFont)MinecraftFont.Font, this.train instanceof ElectricTrain ? (this.train.hasFuel() ? "yes" : "no") : Integer.toString(this.train.getFuel()));
            canvas.drawText(14, 50, (MapFont)MinecraftFont.Font, signedFormat.format(this.train.getDirection()));
            canvas.drawText(14, 65, (MapFont)MinecraftFont.Font, signedFormat.format(this.train.getCombinedLever()));
            canvas.drawText(5, 80, (MapFont)MinecraftFont.Font, this.train.getMinecarts().getProperties().getDisplayName());
        }
        catch (NullPointerException e) {
            return;
        }
    }
}

