/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts.render;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;

public class Images {
    private static Image[] images = new Image[6];
    private static final String[] files = new String[]{"banner.png", "display.png", "fire_off.png", "fire_on.png", "power_off.png", "power_on.png"};

    public static void init() {
        try {
            if (Images.getDirFile(files[0]).exists()) {
                Images.images[0] = ImageIO.read(Images.getDirFile(files[0]));
            } else {
                try {
                    Images.saveImage(Images.getInputStream(files[0]), Images.getDirFile(files[0]));
                    Images.images[0] = ImageIO.read(Images.getDirFile(files[0]));
                }
                catch (Exception e) {
                    Images.images[0] = ImageIO.read(Images.getInputStream(files[0]));
                }
            }
            for (int i = 1; i < files.length; ++i) {
                Images.images[i] = ImageIO.read(Images.getInputStream(files[i]));
            }
        }
        catch (Exception e) {
            Bukkit.getPluginManager().getPlugin("MinecraftTrainSimulator").getLogger().log(Level.SEVERE, "Cannot load image files.", e);
        }
    }

    public static Image getImage(int i) {
        return images[i];
    }

    private static File getDirFile(String name) {
        return new File("plugins/MinecraftTrainSimulator/" + name);
    }

    private static InputStream getInputStream(String name) {
        return Images.class.getResourceAsStream(name);
    }

    private static void saveImage(InputStream from, File to) throws IOException {
        BufferedImage image = ImageIO.read(from);
        to.createNewFile();
        ImageIO.write((RenderedImage)image, "png", to);
    }

    public static void main(String[] args) {
        Images.init();
    }
}

