/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import com.bergerkiller.bukkit.tc.controller.MinecartMember;
import com.bergerkiller.bukkit.tc.controller.MinecartMemberStore;
import com.bergerkiller.bukkit.tc.controller.type.MinecartMemberFurnace;
import de.robingrether.mcts.Train;
import org.bukkit.entity.Minecart;
import org.bukkit.scheduler.BukkitRunnable;

public class Accelerator
extends BukkitRunnable {
    private Train train;
    private int amplifier;

    public Accelerator(Train train, int amplifier) {
        this.train = train;
        this.amplifier = amplifier;
    }

    public void run() {
        MinecartGroup minecarts = this.train.getMinecarts();
        if (minecarts.isEmpty()) {
            this.train.terminate();
            return;
        }
        if (!(this.train.getLeader().getVehicle() instanceof Minecart)) {
            return;
        }
        boolean facingForward = minecarts.head().equals(MinecartMemberStore.convert((Minecart)((Minecart)this.train.getLeader().getVehicle())));
        if (this.train.hasFuel()) {
            double force = minecarts.getAverageForce() * (double)(facingForward ? 1 : -1);
            if (force < this.train.getSpeedLimit() * (double)this.amplifier / 4.0) {
                int furnaceCarts = 0;
                for (MinecartMember minecart : minecarts) {
                    if (!(minecart instanceof MinecartMemberFurnace)) continue;
                    ++furnaceCarts;
                }
                force += this.train.getSpeedLimit() * 0.01 * (double)this.amplifier * (double)this.train.getDirection() * (furnaceCarts < 4 ? (double)furnaceCarts / 2.0 : 2.0);
            }
            if (force > this.train.getSpeedLimit() * (double)this.amplifier / 4.0) {
                force = this.train.getSpeedLimit() * (double)this.amplifier / 4.0;
            }
            minecarts.setForwardForce(force * (double)(facingForward ? 1 : -1));
            this.train.consumeFuel();
        }
    }
}

