/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import com.bergerkiller.bukkit.tc.controller.MinecartMember;
import com.bergerkiller.bukkit.tc.controller.type.MinecartMemberFurnace;
import de.robingrether.mcts.ElectricTrain;
import de.robingrether.mcts.EventListener;
import de.robingrether.mcts.SteamTrain;
import de.robingrether.mcts.Substation;
import de.robingrether.mcts.Train;
import de.robingrether.mcts.bstats.Metrics;
import de.robingrether.mcts.render.Images;
import de.robingrether.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MinecraftTrainSimulator
extends JavaPlugin {
    public static File directory;
    private static MinecraftTrainSimulator instance;
    private Set<Train> trains = new HashSet<Train>();
    Map<String, Substation> substations = new ConcurrentHashMap<String, Substation>();
    Set<Location> catenary;
    private EventListener listener;
    private Metrics metrics;

    public void onEnable() {
        instance = this;
        directory = this.getDataFolder();
        this.listener = new EventListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.checkDirectory();
        this.loadData();
        Images.init();
        this.metrics = new Metrics(this);
        this.metrics.addCustomChart(new Metrics.SingleLineChart("steamTrains"){

            @Override
            public int getValue() {
                int c = 0;
                for (Train train : MinecraftTrainSimulator.this.trains) {
                    if (!(train instanceof SteamTrain)) continue;
                    ++c;
                }
                return c;
            }
        });
        this.metrics.addCustomChart(new Metrics.SingleLineChart("electricTrains"){

            @Override
            public int getValue() {
                int c = 0;
                for (Train train : MinecraftTrainSimulator.this.trains) {
                    if (!(train instanceof ElectricTrain)) continue;
                    ++c;
                }
                return c;
            }
        });
        this.metrics.addCustomChart(new Metrics.SingleLineChart("substations"){

            @Override
            public int getValue() {
                return MinecraftTrainSimulator.this.substations.size();
            }
        });
        this.updateCatenary();
        this.getLogger().log(Level.INFO, String.valueOf(this.getFullName()) + " enabled!");
    }

    public void onDisable() {
        this.terminateTrains();
        this.saveData();
        instance = null;
        this.getLogger().log(Level.INFO, String.valueOf(this.getFullName()) + " disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (cmd.getName().equalsIgnoreCase("mcts")) {
            if (player == null) {
                sender.sendMessage(ChatColor.RED + "This command can only be executed as player.");
            } else if (args.length == 0) {
                this.sendHelp(player);
            } else if (args[0].equalsIgnoreCase("addfuel")) {
                if (this.getTrain(player) == null) {
                    sender.sendMessage(ChatColor.RED + "You are not in a train.");
                } else {
                    Train train = this.getTrain(player);
                    if (train instanceof SteamTrain) {
                        if (SteamTrain.isFuel(player.getItemInHand().getType())) {
                            int fuel = player.getItemInHand().getAmount() * 2000;
                            train.addFuel(fuel);
                            player.setItemInHand(null);
                            sender.sendMessage(ChatColor.GOLD + "Added fuel to the train.");
                        } else {
                            sender.sendMessage(ChatColor.RED + "You have to hold coal in your hand.");
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED + "Electric trains don't need fuel.");
                    }
                }
            } else if (args[0].equalsIgnoreCase("control")) {
                if (this.getTrain(player) == null) {
                    sender.sendMessage(ChatColor.RED + "You are not in a train.");
                } else {
                    Train train = this.getTrain(player);
                    if (train.canLead(player)) {
                        train.setLeader(player);
                        sender.sendMessage(ChatColor.GOLD + "You can now control the train.");
                    } else {
                        sender.sendMessage(ChatColor.RED + "You have to sit in the head or in the tail of the train.");
                    }
                }
            } else if (args[0].equalsIgnoreCase("create")) {
                if (!(player.getVehicle() instanceof Minecart)) {
                    sender.sendMessage(ChatColor.RED + "You have to be in a cart to create a train.");
                } else if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Wrong usage: /mcts create <coal/electric>");
                } else if (StringUtil.equalsIgnoreCase(args[1], "coal", "steam")) {
                    MinecartGroup minecarts = MinecartGroup.get((Entity)player.getVehicle());
                    if (this.getTrain(minecarts) != null) {
                        sender.sendMessage(ChatColor.RED + "This already is a train.");
                    } else if (!this.containsPoweredMinecart(minecarts)) {
                        sender.sendMessage(ChatColor.RED + "You must connect a powered minecart.");
                    } else {
                        SteamTrain train = new SteamTrain(minecarts, this.createNewMap(player.getWorld()));
                        this.trains.add(train);
                        if (train.canLead(player)) {
                            train.setLeader(player);
                        }
                        sender.sendMessage(ChatColor.GOLD + "Created steam train.");
                        PlayerInventory inventory = player.getInventory();
                        int slot = inventory.first(Material.MAP);
                        if (slot > -1) {
                            inventory.getItem(slot).setDurability(train.getMapId());
                        }
                    }
                } else if (args[1].equalsIgnoreCase("electric")) {
                    MinecartGroup minecarts = MinecartGroup.get((Entity)player.getVehicle());
                    if (this.getTrain(minecarts) != null) {
                        sender.sendMessage(ChatColor.RED + "This already is a train.");
                    } else if (!this.containsPoweredMinecart(minecarts)) {
                        sender.sendMessage(ChatColor.RED + "You must connect a powered minecart.");
                    } else {
                        ElectricTrain train = new ElectricTrain(minecarts, this.createNewMap(player.getWorld()));
                        this.trains.add(train);
                        if (train.canLead(player)) {
                            train.setLeader(player);
                        }
                        sender.sendMessage(ChatColor.GOLD + "Created electric train.");
                        PlayerInventory inventory = player.getInventory();
                        int slot = inventory.first(Material.MAP);
                        if (slot > -1) {
                            inventory.getItem(slot).setDurability(train.getMapId());
                        }
                    }
                } else {
                    sender.sendMessage(ChatColor.RED + "Wrong usage: /mcts create <coal/electric>");
                }
            } else if (args[0].equalsIgnoreCase("fuel")) {
                if (this.getTrain(player) == null) {
                    sender.sendMessage(ChatColor.RED + "You are not in a train.");
                } else {
                    Train train = this.getTrain(player);
                    if (train instanceof SteamTrain) {
                        sender.sendMessage(ChatColor.GOLD + "Fuel level: " + train.getFuel());
                    } else {
                        sender.sendMessage(ChatColor.GOLD + "Has energy: " + (train.hasFuel() ? "yes" : "no"));
                    }
                }
            } else {
                this.sendHelp(player);
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("substation")) {
            block82: {
                if (player == null) {
                    sender.sendMessage(ChatColor.RED + "This command can only be executed as player.");
                } else if (args.length == 0) {
                    this.sendHelp(player);
                } else if (args[0].equalsIgnoreCase("create")) {
                    if (args.length < 3) {
                        sender.sendMessage(ChatColor.RED + "Wrong usage: /substation create <name> <voltage>");
                    } else if (this.substations.containsKey(args[1].toLowerCase(Locale.ENGLISH))) {
                        sender.sendMessage(ChatColor.RED + "That name is already used.");
                    } else {
                        try {
                            int voltage = Integer.parseInt(args[2]);
                            if (voltage > 0) {
                                Substation substation = new Substation(args[1].toLowerCase(Locale.ENGLISH), voltage);
                                this.listener.substations.put(player.getName().toLowerCase(Locale.ENGLISH), substation);
                                sender.sendMessage(ChatColor.GOLD + "Place a redstone block with a distance of one block next to your rails.");
                                break block82;
                            }
                            sender.sendMessage(ChatColor.RED + "The voltage may not be 0 or less.");
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(ChatColor.RED + "The voltage must be a valid integer.");
                        }
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    sender.sendMessage(ChatColor.AQUA + "Substations");
                    for (Substation substation : this.substations.values()) {
                        sender.sendMessage(ChatColor.GOLD + " '" + substation.getName() + "' " + substation.getVoltage() + "V (" + (substation.isTurnedOn() ? ChatColor.GREEN + "on" : ChatColor.RED + "off") + ChatColor.GOLD + ") at " + substation.getLocationString());
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (args.length < 2) {
                        sender.sendMessage(ChatColor.RED + "Wrong usage: /substation remove <name>");
                    } else {
                        Substation substation = this.substations.remove(args[1].toLowerCase(Locale.ENGLISH));
                        if (substation == null) {
                            sender.sendMessage(ChatColor.RED + "There is no substation called '" + args[1] + "'");
                        } else {
                            substation.delete();
                            sender.sendMessage(ChatColor.GOLD + "Removed substation '" + args[1] + "'");
                        }
                        this.updateCatenary();
                    }
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("df")) {
            this.executeDirectionChange(sender, player, 1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("dn")) {
            this.executeDirectionChange(sender, player, 0);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("db")) {
            this.executeDirectionChange(sender, player, -1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("p4")) {
            this.executeLeverChange(sender, player, 4);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("p3")) {
            this.executeLeverChange(sender, player, 3);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("p2")) {
            this.executeLeverChange(sender, player, 2);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("p1")) {
            this.executeLeverChange(sender, player, 1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("neutral")) {
            this.executeLeverChange(sender, player, 0);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("b1")) {
            this.executeLeverChange(sender, player, -1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("b2")) {
            this.executeLeverChange(sender, player, -2);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("b3")) {
            this.executeLeverChange(sender, player, -3);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("b4")) {
            this.executeLeverChange(sender, player, -4);
            return true;
        }
        return false;
    }

    private void executeDirectionChange(CommandSender sender, Player player, int direction) {
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "This command can only be executed as player.");
        } else if (this.getTrain(player) == null) {
            sender.sendMessage(ChatColor.RED + "You are not in a train.");
        } else {
            Train train = this.getTrain(player);
            if (train.isLeader(player)) {
                train.setDirection(direction, true);
            } else {
                sender.sendMessage(ChatColor.RED + "You don't control that train.");
            }
        }
    }

    private void executeLeverChange(CommandSender sender, Player player, int status) {
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "This command can only be executed as player.");
        } else if (this.getTrain(player) == null) {
            sender.sendMessage(ChatColor.RED + "You are not in a train.");
        } else {
            Train train = this.getTrain(player);
            if (train.isLeader(player)) {
                train.setCombinedLever(status, true);
            } else {
                sender.sendMessage(ChatColor.RED + "You don't control that train.");
            }
        }
    }

    public String getFullName() {
        return "MinecraftTrainSimulator " + this.getDescription().getVersion();
    }

    private void checkDirectory() {
        if (!directory.isDirectory()) {
            directory.mkdir();
        }
    }

    private void loadData() {
        for (World world : Bukkit.getWorlds()) {
            File dataFile = new File(directory, "substations-" + world.getName() + ".dat");
            if (!dataFile.exists()) continue;
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(dataFile)));
                while ((line = reader.readLine()) != null) {
                    Substation substation = Substation.fromString(line);
                    if (substation == null) continue;
                    this.substations.put(substation.getName(), substation);
                }
                reader.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Cannot load substations.", e);
            }
        }
    }

    private void saveData() {
        for (World world : Bukkit.getWorlds()) {
            File dataFile = new File(directory, "substations-" + world.getName() + ".dat");
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile)));
                for (Substation substation : this.substations.values()) {
                    if (!world.equals(substation.getRedstoneBlockLocation().getWorld())) continue;
                    writer.write(String.valueOf(substation.toString()) + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Cannot save substations.", e);
            }
        }
    }

    private boolean containsPoweredMinecart(MinecartGroup minecarts) {
        for (MinecartMember minecart : minecarts) {
            if (!(minecart instanceof MinecartMemberFurnace)) continue;
            return true;
        }
        return false;
    }

    public void updateCatenary() {
        this.catenary = new HashSet<Location>();
        block0: for (Substation substation : this.substations.values()) {
            if (!substation.isTurnedOn()) continue;
            HashSet<Block> lastCatenary = new HashSet<Block>();
            HashSet<Block> neighbors = new HashSet<Block>();
            HashSet<Location> substationCatenary = new HashSet<Location>();
            int distance = 1;
            this.catenary.add(substation.getIronFenceLocation());
            lastCatenary.add(substation.getIronFenceLocation().getBlock());
            substationCatenary.add(substation.getIronFenceLocation());
            while (distance < substation.getVoltage() / 10) {
                neighbors.clear();
                for (Block block : lastCatenary) {
                    neighbors.addAll(Arrays.asList(this.getNeighbors(block)));
                }
                lastCatenary.clear();
                for (Block block : neighbors) {
                    if (!block.getType().equals((Object)Material.IRON_FENCE) || substationCatenary.contains(block.getLocation())) continue;
                    this.catenary.add(block.getLocation());
                    lastCatenary.add(block);
                    substationCatenary.add(block.getLocation());
                }
                if (lastCatenary.isEmpty()) continue block0;
                ++distance;
            }
        }
    }

    private Block[] getNeighbors(Block block) {
        return new Block[]{block.getRelative(BlockFace.UP), block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST), block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH)};
    }

    public Train getTrain(Player player) {
        return this.getTrain(player, false);
    }

    public Train getTrain(Player player, boolean leader) {
        if (leader) {
            for (Train train : this.trains) {
                if (train == null || train.getLeader() == null || !train.getLeader().equals(player)) continue;
                return train;
            }
        } else if (player.getVehicle() != null) {
            return this.getTrain(MinecartGroup.get((Entity)player.getVehicle()));
        }
        return null;
    }

    public Train getTrain(MinecartGroup minecarts) {
        for (Train train : this.trains) {
            if (!train.getMinecarts().equals((Object)minecarts)) continue;
            return train;
        }
        return null;
    }

    private MapView createNewMap(World world) {
        MapView map = this.getServer().createMap(world);
        return map;
    }

    private void terminateTrains() {
        for (Train train : this.trains) {
            train.terminate();
        }
    }

    private void sendHelp(Player player) {
        player.sendMessage(ChatColor.AQUA + this.getFullName() + " - Help");
        player.sendMessage(ChatColor.GOLD + " /mcts addfuel                       - Add fuel to a train");
        player.sendMessage(ChatColor.GOLD + " /mcts control                       - Control a train");
        player.sendMessage(ChatColor.GOLD + " /mcts create <coal/electric>        - Create a train");
        player.sendMessage(ChatColor.GOLD + " /mcts fuel                          - See a train's fuel level");
        player.sendMessage(ChatColor.GOLD + " /substation create <name> <voltage> - Create a substation");
        player.sendMessage(ChatColor.GOLD + " /substation list                    - List all substations");
        player.sendMessage(ChatColor.GOLD + " /substation remove <name>           - Remove a substation");
        player.sendMessage(ChatColor.GOLD + " /df  /dn  /db - Change the direction");
        player.sendMessage(ChatColor.GOLD + " /p4  /p3  /p2  /p1  /neutral  /b1  /b2  /b3  /b4");
        player.sendMessage(ChatColor.GOLD + " - Control the accelerator and brake");
    }

    public static MinecraftTrainSimulator getInstance() {
        return instance;
    }
}

