/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.mcts;

import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import de.robingrether.mcts.MinecraftTrainSimulator;
import de.robingrether.mcts.SteamTrain;
import de.robingrether.mcts.Substation;
import de.robingrether.mcts.Train;
import de.robingrether.util.ObjectUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EventListener
implements Listener {
    private MinecraftTrainSimulator plugin;
    Map<String, Substation> substations = new ConcurrentHashMap<String, Substation>();

    public EventListener(MinecraftTrainSimulator plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!event.isCancelled()) {
            Block placed = event.getBlockPlaced();
            Player player = event.getPlayer();
            if (placed.getType().equals((Object)Material.REDSTONE_BLOCK)) {
                Substation substation;
                if (this.substations.containsKey(player.getName().toLowerCase(Locale.ENGLISH)) && !(substation = this.substations.get(player.getName().toLowerCase(Locale.ENGLISH))).isRedstoneBlockPlaced()) {
                    substation.placeRedstoneBlock(placed.getLocation());
                    player.sendMessage(ChatColor.GOLD + "Now place a fence (wooden or netherbrick) next to the rail.");
                }
            } else if (ObjectUtil.equals(placed.getType(), Material.FENCE, Material.BIRCH_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE, Material.JUNGLE_FENCE, Material.SPRUCE_FENCE, Material.NETHER_FENCE)) {
                Substation substation;
                if (this.substations.containsKey(player.getName().toLowerCase(Locale.ENGLISH)) && (substation = this.substations.get(player.getName().toLowerCase(Locale.ENGLISH))).isRedstoneBlockPlaced()) {
                    if (ObjectUtil.equals(substation.getRedstoneBlockLocation().subtract(placed.getLocation()).toVector(), new Vector(1, 0, 0), new Vector(-1, 0, 0), new Vector(0, 0, 1), new Vector(0, 0, -1))) {
                        substation.placeFence(placed.getLocation());
                        this.plugin.substations.put(substation.getName(), substation);
                        this.substations.remove(player.getName().toLowerCase(Locale.ENGLISH));
                        player.sendMessage(ChatColor.GOLD + "Created substation. Move the lever to turn it on.");
                    } else {
                        event.setCancelled(true);
                        player.sendMessage(ChatColor.RED + "The fence must be next to the redstone block.");
                    }
                }
            } else if (placed.getType().equals((Object)Material.IRON_FENCE)) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new UpdateCatenaryRunnable(), 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            Block broken = event.getBlock();
            Player player = event.getPlayer();
            if (broken.getType().equals((Object)Material.IRON_FENCE)) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new UpdateCatenaryRunnable(), 1L);
            }
            if (ObjectUtil.equals(broken.getType(), Material.FENCE, Material.BIRCH_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE, Material.JUNGLE_FENCE, Material.SPRUCE_FENCE, Material.NETHER_FENCE, Material.REDSTONE_BLOCK, Material.IRON_FENCE, Material.IRON_BLOCK, Material.LEVER)) {
                for (Substation substation : this.plugin.substations.values()) {
                    if (!substation.isAt(broken.getLocation())) continue;
                    substation.delete();
                    this.plugin.substations.remove(substation.getName());
                    event.setCancelled(true);
                    player.sendMessage(ChatColor.GOLD + "You removed that substation.");
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new UpdateCatenaryRunnable(), 1L);
                }
            }
        }
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent event) {
        Block changed = event.getBlock();
        if (changed.getType().equals((Object)Material.LEVER)) {
            for (Substation substation : this.plugin.substations.values()) {
                if (!substation.isLeverAt(changed.getLocation())) continue;
                if (event.getNewCurrent() > 0) {
                    substation.turnOn();
                    continue;
                }
                substation.turnOff();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        Item item;
        Train train;
        InventoryHolder holder;
        if (!event.isCancelled() && (holder = event.getInventory().getHolder()) instanceof HopperMinecart && (train = this.plugin.getTrain(MinecartGroup.get((Entity)((HopperMinecart)holder)))) instanceof SteamTrain && SteamTrain.isFuel((item = event.getItem()).getItemStack().getType())) {
            train.addFuel(item.getItemStack().getAmount() * 1200);
            event.setCancelled(true);
            item.remove();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (!event.isCancelled()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new VehicleEnterRunnable(event), 10L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onVehicleExit(VehicleExitEvent event) {
        Player player;
        Train train;
        if (!event.isCancelled() && event.getVehicle() instanceof RideableMinecart && event.getExited() instanceof Player && (train = this.plugin.getTrain(player = (Player)event.getExited(), true)) != null && train.isLeader(player)) {
            train.setCombinedLever(-4, false);
        }
    }

    private class UpdateCatenaryRunnable
    implements Runnable {
        private UpdateCatenaryRunnable() {
        }

        @Override
        public void run() {
            EventListener.this.plugin.updateCatenary();
        }
    }

    private class VehicleEnterRunnable
    implements Runnable {
        private VehicleEnterEvent event;

        private VehicleEnterRunnable(VehicleEnterEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event.getVehicle() instanceof RideableMinecart && this.event.getEntered() instanceof Player) {
                PlayerInventory inventory;
                int slot;
                Player player = (Player)this.event.getEntered();
                Train train = EventListener.this.plugin.getTrain(player, false);
                if (train != null && (slot = (inventory = player.getInventory()).first(Material.MAP)) > -1) {
                    inventory.getItem(slot).setDurability(train.getMapId());
                }
            }
        }
    }
}

