/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management.disguise;

import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.management.DisguiseMap;
import de.robingrether.idisguise.management.PlayerHelper;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;

public class DisguiseMapUID
extends DisguiseMap {
    private final Map<UUID, Disguise> disguises;

    public DisguiseMapUID(Map<?, Disguise> map) {
        if (map != null && !map.keySet().isEmpty()) {
            if (map.keySet().iterator().next() instanceof UUID) {
                this.disguises = new ConcurrentHashMap(map);
            } else if (map.keySet().iterator().next() instanceof String) {
                this.disguises = new ConcurrentHashMap<UUID, Disguise>();
                for (Map.Entry<?, Disguise> entry : map.entrySet()) {
                    this.disguises.put(PlayerHelper.getInstance().getUniqueId((String)entry.getKey()), entry.getValue());
                }
            } else {
                this.disguises = new ConcurrentHashMap<UUID, Disguise>();
            }
        } else {
            this.disguises = new ConcurrentHashMap<UUID, Disguise>();
        }
    }

    @Override
    public boolean isDisguised(OfflinePlayer offlinePlayer) {
        return this.disguises.containsKey(offlinePlayer.getUniqueId());
    }

    @Override
    public Disguise getDisguise(OfflinePlayer offlinePlayer) {
        return this.disguises.get(offlinePlayer.getUniqueId());
    }

    public Map<UUID, Disguise> getMap() {
        return this.disguises;
    }

    public Set<UUID> getDisguisedPlayers() {
        return this.disguises.keySet();
    }

    @Override
    public void updateDisguise(OfflinePlayer offlinePlayer, Disguise disguise) {
        this.disguises.put(offlinePlayer.getUniqueId(), disguise);
    }

    @Override
    public Disguise removeDisguise(OfflinePlayer offlinePlayer) {
        return this.disguises.remove(offlinePlayer.getUniqueId());
    }
}

