/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management.channel;

import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.ChannelInjector;
import de.robingrether.idisguise.management.PacketHandler;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.Sounds;
import de.robingrether.idisguise.management.VersionHelper;
import de.robingrether.idisguise.management.channel.InjectedPlayerConnection;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class ChannelInjectorPC
extends ChannelInjector {
    private final Map<Player, InjectedPlayerConnection> playerConnectionMap;
    private Constructor<?> playerConnectionConstructor;

    public ChannelInjectorPC() {
        block2: {
            this.playerConnectionMap = new ConcurrentHashMap<Player, InjectedPlayerConnection>();
            try {
                this.playerConnectionConstructor = Class.forName("de.robingrether.idisguise.management.channel.InjectedPlayerConnection" + VersionHelper.getVersionCode().replaceAll("[^0-9]*", "")).getConstructor(this.getClass(), Player.class, Object.class);
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block2;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot find the required player connection constructor.", e);
            }
        }
    }

    @Override
    public synchronized void inject(Player player) {
        block2: {
            try {
                InjectedPlayerConnection playerConnection = (InjectedPlayerConnection)this.playerConnectionConstructor.newInstance(this, player, Reflection.EntityPlayer_playerConnection.get(Reflection.CraftPlayer_getHandle.invoke((Object)player, new Object[0])));
                this.playerConnectionMap.put(player, playerConnection);
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block2;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot inject the given player connection: " + player.getName(), e);
            }
        }
    }

    @Override
    public synchronized void remove(Player player) {
        block3: {
            try {
                InjectedPlayerConnection playerConnection = this.playerConnectionMap.remove(player);
                if (playerConnection != null) {
                    playerConnection.resetToDefaultConnection();
                }
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block3;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot remove the given player connection: " + player.getName(), e);
            }
        }
    }

    public Object[] handlePacketOut(Player observer, Object packet) {
        try {
            if (Reflection.PacketPlayOutNamedEntitySpawn.isInstance(packet)) {
                return PacketHandler.getInstance().handlePacketPlayOutNamedEntitySpawn(observer, packet);
            }
            if (Reflection.PacketPlayOutPlayerInfo.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutPlayerInfo(observer, packet)};
            }
            if (Reflection.PacketPlayOutBed.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutBed(observer, packet)};
            }
            if (Reflection.PacketPlayOutAnimation.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutAnimation(observer, packet)};
            }
            if (Reflection.PacketPlayOutEntityMetadata.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutEntityMetadata(observer, packet)};
            }
            if (Reflection.PacketPlayOutEntity.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutEntity(observer, packet)};
            }
            if (Reflection.PacketPlayOutEntityTeleport.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutEntityTeleport(observer, packet)};
            }
            if (Reflection.PacketPlayOutUpdateAttributes.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutUpdateAttributes(observer, packet)};
            }
            if (Reflection.PacketPlayOutCollect.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutCollect(observer, packet)};
            }
            if (Sounds.isEnabled() && Reflection.PacketPlayOutNamedSoundEffect.isInstance(packet)) {
                return new Object[]{PacketHandler.getInstance().handlePacketPlayOutNamedSoundEffect(observer, packet)};
            }
            return new Object[]{packet};
        }
        catch (Exception e) {
            if (VersionHelper.debug()) {
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot handle packet out: " + packet.getClass().getSimpleName() + " to " + observer.getName(), e);
            }
            return new Object[0];
        }
    }
}

