/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.management.ChannelInjector;
import de.robingrether.idisguise.management.DisguiseManager;
import de.robingrether.idisguise.management.GhostFactory;
import de.robingrether.idisguise.management.PacketHandler;
import de.robingrether.idisguise.management.PacketHelper;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.Sounds;
import de.robingrether.idisguise.management.channel.ChannelInjectorPC;
import de.robingrether.util.StringUtil;
import org.bukkit.Bukkit;

public class VersionHelper {
    private static final String[] versions = new String[]{"v1_7_R3", "v1_7_R4", "v1_8_R1", "v1_8_R2", "v1_8_R3", "v1_9_R1", "v1_9_R2", "v1_10_R1", "v1_11_R1"};
    private static boolean initialized = false;
    private static String versionCode;
    private static String orgBukkitCraftbukkit;
    private static String netMinecraftServer;
    private static String orgBukkitCraftbukkitVersioned;
    private static String netMinecraftServerVersioned;
    private static boolean debug;
    private static boolean require1_8;
    private static boolean require1_9;
    private static boolean require1_10;
    private static boolean require1_11;

    static {
        orgBukkitCraftbukkit = "org.bukkit.craftbukkit";
        netMinecraftServer = "net.minecraft.server";
    }

    public static String getVersionCode() {
        return versionCode;
    }

    public static String getOBCPackage() {
        return orgBukkitCraftbukkitVersioned;
    }

    public static String getNMSPackage() {
        return netMinecraftServerVersioned;
    }

    public static boolean debug() {
        return debug;
    }

    public static boolean requireVersion(String requiredVersion) {
        if (!StringUtil.equals((String)requiredVersion, (String[])versions)) {
            return false;
        }
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            if (version.equals(requiredVersion)) {
                return true;
            }
            if (version.equals(versionCode)) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public static boolean require1_11() {
        return require1_11;
    }

    public static boolean require1_10() {
        return require1_10;
    }

    public static boolean require1_9() {
        return require1_9;
    }

    public static boolean require1_8() {
        return require1_8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean init(boolean debug) {
        if (initialized) {
            return false;
        }
        try {
            versionCode = Bukkit.getServer().getClass().getPackage().getName().substring(orgBukkitCraftbukkit.length() + 1);
            orgBukkitCraftbukkitVersioned = String.valueOf(orgBukkitCraftbukkit) + "." + versionCode;
            netMinecraftServerVersioned = String.valueOf(netMinecraftServer) + "." + versionCode;
            VersionHelper.debug = debug;
            require1_8 = VersionHelper.requireVersion("v1_8_R1");
            require1_9 = VersionHelper.requireVersion("v1_9_R1");
            require1_10 = VersionHelper.requireVersion("v1_10_R1");
            require1_11 = VersionHelper.requireVersion("v1_11_R1");
            switch (versionCode) {
                case "v1_7_R3": 
                case "v1_7_R4": {
                    Reflection.init("reflection/" + versionCode + ".txt", netMinecraftServerVersioned, orgBukkitCraftbukkitVersioned);
                    DisguiseManager.setInstance(new DisguiseManager());
                    PlayerHelper.setInstance((PlayerHelper)Class.forName("de.robingrether.idisguise.management.player.PlayerHelperUID17").newInstance());
                    Sounds.init("sounds/17_18.txt");
                    break;
                }
                case "v1_8_R1": 
                case "v1_8_R2": 
                case "v1_8_R3": {
                    Reflection.init("reflection/" + versionCode + ".txt", netMinecraftServerVersioned, orgBukkitCraftbukkitVersioned);
                    DisguiseManager.setInstance((DisguiseManager)Class.forName("de.robingrether.idisguise.management.disguise.DisguiseManager18").newInstance());
                    PlayerHelper.setInstance((PlayerHelper)Class.forName("de.robingrether.idisguise.management.player.PlayerHelperUID18").newInstance());
                    Sounds.init("sounds/17_18.txt");
                    break;
                }
                case "v1_9_R1": 
                case "v1_9_R2": {
                    Reflection.init("reflection/v1_9_R1.txt", netMinecraftServerVersioned, orgBukkitCraftbukkitVersioned);
                    DisguiseManager.setInstance(new DisguiseManager());
                    PlayerHelper.setInstance((PlayerHelper)Class.forName("de.robingrether.idisguise.management.player.PlayerHelperUID18").newInstance());
                    Sounds.init("sounds/111.txt");
                    break;
                }
                case "v1_10_R1": {
                    Reflection.init("reflection/v1_10_R1.txt", netMinecraftServerVersioned, orgBukkitCraftbukkitVersioned);
                    DisguiseManager.setInstance(new DisguiseManager());
                    PlayerHelper.setInstance((PlayerHelper)Class.forName("de.robingrether.idisguise.management.player.PlayerHelperUID18").newInstance());
                    Sounds.init("sounds/111.txt");
                    break;
                }
                case "v1_11_R1": {
                    Reflection.init("reflection/v1_11_R1.txt", netMinecraftServerVersioned, orgBukkitCraftbukkitVersioned);
                    DisguiseManager.setInstance(new DisguiseManager());
                    PlayerHelper.setInstance((PlayerHelper)Class.forName("de.robingrether.idisguise.management.player.PlayerHelperUID18").newInstance());
                    Sounds.init("sounds/111.txt");
                    break;
                }
                default: {
                    return false;
                }
            }
            ChannelInjector.setInstance(new ChannelInjectorPC());
            GhostFactory.setInstance(new GhostFactory());
            PacketHandler.setInstance(new PacketHandler());
            PacketHelper.setInstance(new PacketHelper());
            initialized = true;
            return true;
        }
        catch (Exception e) {
            initialized = false;
            return false;
        }
    }
}

