/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.MobDisguise;
import de.robingrether.idisguise.disguise.SizedDisguise;
import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.VersionHelper;
import de.robingrether.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sounds {
    private static Map<DisguiseType, Sounds> entitySounds = new ConcurrentHashMap<DisguiseType, Sounds>();
    private static boolean enabled = false;
    private static String[] soundsToReplace;
    private static final Pattern soundPattern;
    protected String death;
    protected String fallBig;
    protected String fallSmall;
    protected String hit;
    protected String splash;
    protected String swim;

    static {
        soundPattern = Pattern.compile("([A-Z_]+)->(.+)");
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        Sounds.enabled = enabled;
    }

    public static Sounds getSoundsForEntity(DisguiseType type) {
        return entitySounds.get((Object)type);
    }

    public static boolean setSoundsForEntity(DisguiseType type, Sounds sounds) {
        if (type.isMob()) {
            entitySounds.put(type, sounds);
            return true;
        }
        return false;
    }

    public static boolean isSoundFromPlayer(String sound) {
        return StringUtil.equals((String)sound, (String[])soundsToReplace);
    }

    public static String replaceSoundFromPlayer(String sound, MobDisguise disguise) {
        Sounds sounds = Sounds.getSoundsForEntity(disguise.getType());
        if (sounds != null) {
            String replacement = null;
            if (sound.equals(soundsToReplace[0])) {
                replacement = sounds.death(disguise);
            } else if (sound.equals(soundsToReplace[1])) {
                replacement = sounds.fallBig(disguise);
            } else if (sound.equals(soundsToReplace[2])) {
                replacement = sounds.fallSmall(disguise);
            } else if (sound.equals(soundsToReplace[3])) {
                replacement = sounds.hit(disguise);
            } else if (sound.equals(soundsToReplace[4])) {
                replacement = sounds.splash(disguise);
            } else if (sound.equals(soundsToReplace[5])) {
                replacement = sounds.swim(disguise);
            }
            if (replacement != null && !replacement.isEmpty()) {
                return replacement;
            }
        }
        return null;
    }

    public static void init(String file) {
        block17: {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(Sounds.class.getResourceAsStream(file)));
                while ((line = reader.readLine()) != null) {
                    Matcher soundMatcher = soundPattern.matcher(line);
                    if (!soundMatcher.matches()) continue;
                    try {
                        String name = soundMatcher.group(1);
                        final String[] arguments = soundMatcher.group(2).split(",", -1);
                        switch (name) {
                            case "_": {
                                soundsToReplace = arguments;
                                break;
                            }
                            case "SLIME": 
                            case "MAGMA_CUBE": {
                                Sounds.setSoundsForEntity(DisguiseType.valueOf(name), new Sounds(null, arguments[0], arguments[1], null, arguments[2], arguments[3]){

                                    @Override
                                    public String death(MobDisguise disguise) {
                                        return disguise instanceof SizedDisguise && ((SizedDisguise)disguise).getSize() > 1 ? arguments[4] : arguments[5];
                                    }

                                    @Override
                                    public String hit(MobDisguise disguise) {
                                        return disguise instanceof SizedDisguise && ((SizedDisguise)disguise).getSize() > 1 ? arguments[6] : arguments[7];
                                    }
                                });
                                break;
                            }
                            default: {
                                Sounds.setSoundsForEntity(DisguiseType.valueOf(name), new Sounds(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]));
                                break;
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (!VersionHelper.debug()) continue;
                        iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot parse line: " + line, e);
                    }
                }
            }
            catch (IOException e) {
                if (!VersionHelper.debug()) break block17;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot load the required sound effect configuration.", e);
            }
        }
    }

    public Sounds(String death, String fallBig, String fallSmall, String hit, String splash, String swim) {
        this.death = death;
        this.fallBig = fallBig;
        this.fallSmall = fallSmall;
        this.hit = hit;
        this.splash = splash;
        this.swim = swim;
    }

    public String death(MobDisguise disguise) {
        return this.death;
    }

    public String fallBig(MobDisguise disguise) {
        return this.fallBig;
    }

    public String fallSmall(MobDisguise disguise) {
        return this.fallSmall;
    }

    public String hit(MobDisguise disguise) {
        return this.hit;
    }

    public String splash(MobDisguise disguise) {
        return this.splash;
    }

    public String swim(MobDisguise disguise) {
        return this.swim;
    }
}

