/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.VersionHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PlayerHelper {
    private static PlayerHelper instance;
    private final String API_URL = "https://api.mojang.com/user/profiles/";
    private Map<Integer, Player> players = new HashMap<Integer, Player>();

    public static PlayerHelper getInstance() {
        return instance;
    }

    static void setInstance(PlayerHelper instance) {
        PlayerHelper.instance = instance;
    }

    public PlayerHelper() {
        for (Player player : Reflection.getOnlinePlayers()) {
            this.players.put(player.getEntityId(), player);
        }
    }

    public synchronized void addPlayer(Player player) {
        this.players.put(player.getEntityId(), player);
    }

    public synchronized void removePlayer(Player player) {
        this.players.remove(player.getEntityId());
    }

    public Player getPlayerByEntityId(int entityId) {
        return this.players.get(entityId);
    }

    public String getCaseCorrectedName(String name) {
        return name;
    }

    public UUID getUniqueId(String name) {
        return null;
    }

    public String getName(UUID uniqueId) {
        BufferedReader reader = null;
        try {
            URL url = new URL("https://api.mojang.com/user/profiles/" + uniqueId.toString().replace("-", "") + "/names");
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("User-Agent", String.valueOf(iDisguise.getInstance().getFullName().replace(' ', '/')) + " (by RobinGrether)");
            connection.setDoOutput(true);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String response = reader.readLine();
            JSONArray array = (JSONArray)JSONValue.parse((String)response);
            JSONObject object = (JSONObject)array.get(0);
            String string = (String)object.get((Object)"name");
            return string;
        }
        catch (IOException e) {
            if (VersionHelper.debug()) {
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot convert the stored disguise data.", e);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public Object getGameProfile(UUID uniqueId, String skinName, String displayName) {
        return null;
    }

    public void loadGameProfileAsynchronously(String skinName) {
    }

    public boolean isGameProfileLoaded(String skinName) {
        return true;
    }

    public void waitForGameProfile(String skinName) {
    }
}

