/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.api.PlayerInteractDisguisedPlayerEvent;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.FallingBlockDisguise;
import de.robingrether.idisguise.disguise.MobDisguise;
import de.robingrether.idisguise.disguise.ObjectDisguise;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.DisguiseManager;
import de.robingrether.idisguise.management.PacketHelper;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.Sounds;
import de.robingrether.idisguise.management.VersionHelper;
import de.robingrether.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketHandler {
    private static PacketHandler instance;

    public static PacketHandler getInstance() {
        return instance;
    }

    static void setInstance(PacketHandler instance) {
        PacketHandler.instance = instance;
    }

    public Object handlePacketPlayInUseEntity(final Player observer, Object packet) throws Exception {
        final Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayInUseEntity_entityId.getInt(packet));
        boolean attack = Reflection.PacketPlayInUseEntity_getAction.invoke(packet, new Object[0]).equals(Reflection.EnumEntityUseAction_ATTACK.get(null));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && !attack) {
            if (ObjectUtil.equals((Object)((Object)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType()), (Object[])new Object[]{DisguiseType.SHEEP, DisguiseType.WOLF})) {
                BukkitRunnable runnable = new BukkitRunnable(){

                    public void run() {
                        DisguiseManager.getInstance().resendPackets(player);
                        observer.updateInventory();
                    }
                };
                runnable.runTaskLater((Plugin)iDisguise.getInstance(), 2L);
            }
            Bukkit.getPluginManager().callEvent((Event)new PlayerInteractDisguisedPlayerEvent(observer, player));
            return null;
        }
        return packet;
    }

    public Object[] handlePacketPlayOutNamedEntitySpawn(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutNamedEntitySpawn_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer)) {
            Object[] spawnPackets = PacketHelper.getInstance().getPackets(player);
            if (Reflection.PacketPlayOutSpawnEntityLiving.isInstance(spawnPackets[0]) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.ENDER_DRAGON)) {
                byte yaw = Reflection.PacketPlayOutSpawnEntityLiving_yaw.getByte(spawnPackets[0]);
                yaw = yaw < 0 ? (byte)(yaw + 128) : (byte)(yaw - 128);
                Reflection.PacketPlayOutSpawnEntityLiving_yaw.setByte(spawnPackets[0], yaw);
            } else if (Reflection.PacketPlayOutSpawnEntity.isInstance(spawnPackets[0]) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.FALLING_BLOCK) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof FallingBlockDisguise && ((FallingBlockDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).onlyBlockCoordinates()) {
                if (VersionHelper.require1_9()) {
                    Reflection.PacketPlayOutSpawnEntity_x.setDouble(spawnPackets[0], Math.floor(player.getLocation().getX()) + 0.5);
                    Reflection.PacketPlayOutSpawnEntity_y.setDouble(spawnPackets[0], Math.floor(player.getLocation().getY()));
                    Reflection.PacketPlayOutSpawnEntity_z.setDouble(spawnPackets[0], Math.floor(player.getLocation().getZ()) + 0.5);
                } else {
                    Reflection.PacketPlayOutSpawnEntity_x.setInt(spawnPackets[0], (int)((Math.floor(player.getLocation().getX()) + 0.5) * 32.0));
                    Reflection.PacketPlayOutSpawnEntity_y.setInt(spawnPackets[0], (int)(Math.floor(player.getLocation().getY()) * 32.0));
                    Reflection.PacketPlayOutSpawnEntity_z.setInt(spawnPackets[0], (int)((Math.floor(player.getLocation().getZ()) + 0.5) * 32.0));
                }
            }
            return spawnPackets;
        }
        return new Object[]{packet};
    }

    public Object handlePacketPlayOutPlayerInfo(Player observer, Object packet) throws Exception {
        if (VersionHelper.require1_8()) {
            Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
            List playerInfoList = (List)Reflection.PacketPlayOutPlayerInfo_playerInfoList.get(customizablePacket);
            ArrayList<Object> itemsToAdd = new ArrayList<Object>();
            ArrayList itemsToRemove = new ArrayList();
            for (Object playerInfo : playerInfoList) {
                OfflinePlayer offlinePlayer = (OfflinePlayer)Reflection.Bukkit_getOfflinePlayer.invoke(null, Reflection.GameProfile_getProfileId.invoke(Reflection.PlayerInfoData_getProfile.invoke(playerInfo, new Object[0]), new Object[0]));
                if (offlinePlayer == null || offlinePlayer == observer || !DisguiseManager.getInstance().isDisguisedTo(offlinePlayer, observer)) continue;
                Object newPlayerInfo = PacketHelper.getInstance().getPlayerInfo(offlinePlayer, customizablePacket, (Integer)Reflection.PlayerInfoData_getPing.invoke(playerInfo, new Object[0]), Reflection.PlayerInfoData_getGamemode.invoke(playerInfo, new Object[0]), Reflection.PlayerInfoData_getDisplayName.invoke(playerInfo, new Object[0]));
                itemsToRemove.add(playerInfo);
                if (newPlayerInfo == null) continue;
                itemsToAdd.add(newPlayerInfo);
            }
            playerInfoList.removeAll(itemsToRemove);
            playerInfoList.addAll(itemsToAdd);
            return customizablePacket;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)ChatColor.stripColor((String)((String)Reflection.PacketPlayOutPlayerInfo_playerName.get(packet))));
        if (offlinePlayer != null && offlinePlayer != observer && DisguiseManager.getInstance().isDisguisedTo(offlinePlayer, observer)) {
            String name = (String)PacketHelper.getInstance().getPlayerInfo(offlinePlayer, null, 0, null, Reflection.PacketPlayOutPlayerInfo_playerName.get(packet));
            if (name != null) {
                Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
                Reflection.PacketPlayOutPlayerInfo_playerName.set(customizablePacket, name);
                return customizablePacket;
            }
            return null;
        }
        return packet;
    }

    public Object handlePacketPlayOutBed(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutBed_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && !(DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise)) {
            return null;
        }
        return packet;
    }

    public Object handlePacketPlayOutAnimation(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutAnimation_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && !(DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise) && (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof MobDisguise ? Reflection.PacketPlayOutAnimation_animationType.getInt(packet) == 2 : DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof ObjectDisguise && ObjectUtil.equals((Object)Reflection.PacketPlayOutAnimation_animationType.getInt(packet), (Object[])new Object[]{0, 2, 3}))) {
            return null;
        }
        return packet;
    }

    public Object handlePacketPlayOutEntityMetadata(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutEntityMetadata_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && !(DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise)) {
            Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
            boolean living = DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof MobDisguise;
            List metadataList = (List)Reflection.PacketPlayOutEntityMetadata_metadataList.get(customizablePacket);
            ArrayList itemsToRemove = new ArrayList();
            for (Object metadataItem : metadataList) {
                int metadataId = PacketHelper.getInstance().getMetadataId(metadataItem);
                if (metadataId <= 0 || living && metadataId >= 6 && metadataId <= 9) continue;
                itemsToRemove.add(metadataItem);
            }
            metadataList.removeAll(itemsToRemove);
            return customizablePacket;
        }
        return packet;
    }

    public Object handlePacketPlayOutEntity(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutEntity_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer)) {
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.ENDER_DRAGON)) {
                Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
                byte yaw = Reflection.PacketPlayOutEntity_yaw.getByte(customizablePacket);
                yaw = yaw < 0 ? (byte)(yaw + 128) : (byte)(yaw - 128);
                Reflection.PacketPlayOutEntity_yaw.setByte(customizablePacket, yaw);
                return customizablePacket;
            }
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.FALLING_BLOCK) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof FallingBlockDisguise && ((FallingBlockDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).onlyBlockCoordinates()) {
                Object customizablePacket = Reflection.PacketPlayOutEntityTeleport_new.newInstance(new Object[0]);
                Reflection.PacketPlayOutEntityTeleport_entityId.setInt(customizablePacket, player.getEntityId());
                if (VersionHelper.require1_9()) {
                    Reflection.PacketPlayOutEntityTeleport_x.setDouble(customizablePacket, Math.floor(player.getLocation().getX()) + 0.5);
                    Reflection.PacketPlayOutEntityTeleport_y.setDouble(customizablePacket, Math.floor(player.getLocation().getY()));
                    Reflection.PacketPlayOutEntityTeleport_z.setDouble(customizablePacket, Math.floor(player.getLocation().getZ()) + 0.5);
                } else {
                    Reflection.PacketPlayOutEntityTeleport_x.setInt(customizablePacket, (int)((Math.floor(player.getLocation().getX()) + 0.5) * 32.0));
                    Reflection.PacketPlayOutEntityTeleport_y.setInt(customizablePacket, (int)(Math.floor(player.getLocation().getY()) * 32.0));
                    Reflection.PacketPlayOutEntityTeleport_z.setInt(customizablePacket, (int)((Math.floor(player.getLocation().getZ()) + 0.5) * 32.0));
                }
                Reflection.PacketPlayOutEntityTeleport_yaw.setByte(customizablePacket, (byte)(player.getLocation().getYaw() * 256.0f / 360.0f));
                Reflection.PacketPlayOutEntityTeleport_pitch.setByte(customizablePacket, (byte)(player.getLocation().getPitch() * 256.0f / 360.0f));
                if (VersionHelper.require1_8()) {
                    Reflection.PacketPlayOutEntityTeleport_isOnGround.setBoolean(customizablePacket, Reflection.PacketPlayOutEntity_isOnGround.getBoolean(packet));
                }
                return customizablePacket;
            }
        }
        return packet;
    }

    public Object handlePacketPlayOutEntityTeleport(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutEntityTeleport_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer)) {
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.ENDER_DRAGON)) {
                Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
                byte yaw = Reflection.PacketPlayOutEntityTeleport_yaw.getByte(customizablePacket);
                yaw = yaw < 0 ? (byte)(yaw + 128) : (byte)(yaw - 128);
                Reflection.PacketPlayOutEntityTeleport_yaw.setByte(customizablePacket, yaw);
                return customizablePacket;
            }
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.FALLING_BLOCK) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof FallingBlockDisguise && ((FallingBlockDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).onlyBlockCoordinates()) {
                Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
                if (VersionHelper.require1_9()) {
                    Reflection.PacketPlayOutEntityTeleport_x.setDouble(customizablePacket, Math.floor(player.getLocation().getX()) + 0.5);
                    Reflection.PacketPlayOutEntityTeleport_y.setDouble(customizablePacket, Math.floor(player.getLocation().getY()));
                    Reflection.PacketPlayOutEntityTeleport_z.setDouble(customizablePacket, Math.floor(player.getLocation().getZ()) + 0.5);
                } else {
                    Reflection.PacketPlayOutEntityTeleport_x.setInt(customizablePacket, (int)((Math.floor(player.getLocation().getX()) + 0.5) * 32.0));
                    Reflection.PacketPlayOutEntityTeleport_y.setInt(customizablePacket, (int)(Math.floor(player.getLocation().getY()) * 32.0));
                    Reflection.PacketPlayOutEntityTeleport_z.setInt(customizablePacket, (int)((Math.floor(player.getLocation().getZ()) + 0.5) * 32.0));
                }
                return customizablePacket;
            }
        }
        return packet;
    }

    public Object handlePacketPlayOutUpdateAttributes(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutUpdateAttributes_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof ObjectDisguise) {
            return null;
        }
        return packet;
    }

    public Object handlePacketPlayOutCollect(Player observer, Object packet) throws Exception {
        Player player = PlayerHelper.getInstance().getPlayerByEntityId(Reflection.PacketPlayOutCollect_entityId.getInt(packet));
        if (player != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof ObjectDisguise) {
            return null;
        }
        return packet;
    }

    public Object handlePacketPlayOutNamedSoundEffect(Player observer, Object packet) throws Exception {
        String soundEffect = PacketHelper.getInstance().soundEffectToString(Reflection.PacketPlayOutNamedSoundEffect_soundEffect.get(packet));
        if (Sounds.isSoundFromPlayer(soundEffect)) {
            Player player;
            Object entityHuman;
            Object object = entityHuman = VersionHelper.require1_9() ? Reflection.World_findNearbyPlayer.invoke(Reflection.Entity_world.get(Reflection.CraftPlayer_getHandle.invoke((Object)observer, new Object[0])), (double)Reflection.PacketPlayOutNamedSoundEffect_x.getInt(packet) / 8.0, (double)Reflection.PacketPlayOutNamedSoundEffect_y.getInt(packet) / 8.0, (double)Reflection.PacketPlayOutNamedSoundEffect_z.getInt(packet) / 8.0, 1.0, false) : Reflection.World_findNearbyPlayer.invoke(Reflection.Entity_world.get(Reflection.CraftPlayer_getHandle.invoke((Object)observer, new Object[0])), (double)Reflection.PacketPlayOutNamedSoundEffect_x.getInt(packet) / 8.0, (double)Reflection.PacketPlayOutNamedSoundEffect_y.getInt(packet) / 8.0, (double)Reflection.PacketPlayOutNamedSoundEffect_z.getInt(packet) / 8.0, 1.0);
            if (Reflection.EntityPlayer.isInstance(entityHuman) && (player = (Player)Reflection.EntityPlayer_getBukkitEntity.invoke(entityHuman, new Object[0])) != null && player != observer && DisguiseManager.getInstance().isDisguisedTo((OfflinePlayer)player, observer)) {
                if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof MobDisguise) {
                    String newSoundEffect = Sounds.replaceSoundFromPlayer(soundEffect, (MobDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player));
                    if (newSoundEffect != null) {
                        Object customizablePacket = PacketHelper.getInstance().clonePacket(packet);
                        Reflection.PacketPlayOutNamedSoundEffect_soundEffect.set(customizablePacket, PacketHelper.getInstance().soundEffectFromString(newSoundEffect));
                        return customizablePacket;
                    }
                    return null;
                }
                if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof ObjectDisguise) {
                    return null;
                }
            }
        }
        return packet;
    }
}

