/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.management.DisguiseManager;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.VersionHelper;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GhostFactory {
    private static GhostFactory instance;
    private final String GHOST_TEAM_NAME = "Ghosts";
    private boolean enabled = false;
    private Team ghostTeam;
    private Set<OfflinePlayer> ghosts;
    private int taskId;

    public static GhostFactory getInstance() {
        return instance;
    }

    static void setInstance(GhostFactory instance) {
        GhostFactory.instance = instance;
    }

    public void enable(Plugin plugin) {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.ghosts = new HashSet<OfflinePlayer>();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        this.ghostTeam = scoreboard.getTeam("Ghosts");
        if (this.ghostTeam == null) {
            this.ghostTeam = scoreboard.registerNewTeam("Ghosts");
        }
        this.ghostTeam.setCanSeeFriendlyInvisibles(true);
        for (Player player : Reflection.getOnlinePlayers()) {
            this.addPlayer(player.getName());
        }
        for (OfflinePlayer offlinePlayer : DisguiseManager.getInstance().getDisguisedPlayers()) {
            if (!(DisguiseManager.getInstance().getDisguise(offlinePlayer) instanceof PlayerDisguise) || !((PlayerDisguise)DisguiseManager.getInstance().getDisguise(offlinePlayer)).isGhost()) continue;
            this.addPlayer(((PlayerDisguise)DisguiseManager.getInstance().getDisguise(offlinePlayer)).getSkinName());
            if (!offlinePlayer.isOnline()) continue;
            this.addGhost(offlinePlayer.getPlayer());
        }
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(plugin, new Runnable(){

            @Override
            public void run() {
                for (OfflinePlayer offlinePlayer : GhostFactory.this.ghosts) {
                    if (!offlinePlayer.isOnline()) continue;
                    offlinePlayer.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
                }
            }
        }, 1200L, 1200L);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        Bukkit.getScheduler().cancelTask(this.taskId);
        for (OfflinePlayer offlinePlayer : this.ghosts) {
            if (!offlinePlayer.isOnline()) continue;
            offlinePlayer.getPlayer().removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        this.ghostTeam.unregister();
    }

    public void addPlayer(String name) {
        if (this.enabled) {
            if (VersionHelper.requireVersion("v1_8_R3")) {
                this.ghostTeam.addEntry(name);
            } else {
                this.ghostTeam.addPlayer(Bukkit.getOfflinePlayer((String)name));
            }
        }
    }

    public boolean addGhost(Player player) {
        if (this.enabled) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
            return this.ghosts.add((OfflinePlayer)player);
        }
        return false;
    }

    public boolean removeGhost(Player player) {
        if (this.enabled) {
            boolean remove = this.ghosts.remove(player);
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            return remove;
        }
        return false;
    }
}

