/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.management;

import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.DisguiseMap;
import de.robingrether.idisguise.management.GhostFactory;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.idisguise.management.Reflection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DisguiseManager {
    private static DisguiseManager instance;
    protected DisguiseMap disguiseMap = DisguiseMap.emptyMap();

    public static DisguiseManager getInstance() {
        return instance;
    }

    static void setInstance(DisguiseManager instance) {
        DisguiseManager.instance = instance;
    }

    public synchronized void disguise(final OfflinePlayer offlinePlayer, final Disguise disguise) {
        if (disguise instanceof PlayerDisguise && !PlayerHelper.getInstance().isGameProfileLoaded(((PlayerDisguise)disguise).getSkinName())) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)iDisguise.getInstance(), new Runnable(){

                @Override
                public void run() {
                    PlayerHelper.getInstance().waitForGameProfile(((PlayerDisguise)disguise).getSkinName());
                    Bukkit.getScheduler().runTask((Plugin)iDisguise.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            DisguiseManager.this.disguise(offlinePlayer, disguise);
                        }
                    });
                }
            });
            return;
        }
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            Disguise oldDisguise = this.disguiseMap.getDisguise((OfflinePlayer)player);
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.hidePlayer(player);
            }
            if (oldDisguise instanceof PlayerDisguise && oldDisguise.getType().equals((Object)DisguiseType.GHOST)) {
                GhostFactory.getInstance().removeGhost(player);
            }
            this.disguiseMap.updateDisguise((OfflinePlayer)player, disguise);
            if (disguise instanceof PlayerDisguise && ((PlayerDisguise)disguise).isGhost()) {
                GhostFactory.getInstance().addPlayer(((PlayerDisguise)disguise).getSkinName());
                GhostFactory.getInstance().addGhost(player);
            }
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.showPlayer(player);
            }
        } else {
            this.disguiseMap.updateDisguise(offlinePlayer, disguise);
        }
    }

    public synchronized Disguise undisguise(OfflinePlayer offlinePlayer) {
        if (offlinePlayer.isOnline()) {
            Player player = offlinePlayer.getPlayer();
            Disguise disguise = this.disguiseMap.getDisguise((OfflinePlayer)player);
            if (disguise == null) {
                return null;
            }
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.hidePlayer(player);
            }
            if (disguise instanceof PlayerDisguise && disguise.getType().equals((Object)DisguiseType.GHOST)) {
                GhostFactory.getInstance().removeGhost(player);
            }
            this.disguiseMap.removeDisguise((OfflinePlayer)player);
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.showPlayer(player);
            }
            return disguise;
        }
        return this.disguiseMap.removeDisguise(offlinePlayer);
    }

    public synchronized void undisguiseAll() {
        for (OfflinePlayer offlinePlayer : this.getDisguisedPlayers()) {
            this.undisguise(offlinePlayer);
        }
    }

    public boolean isDisguised(OfflinePlayer offlinePlayer) {
        return this.disguiseMap.isDisguised(offlinePlayer);
    }

    public boolean isDisguisedTo(OfflinePlayer offlinePlayer, Player observer) {
        return this.disguiseMap.isDisguised(offlinePlayer) && this.disguiseMap.getDisguise(offlinePlayer).isVisibleTo(observer);
    }

    public Disguise getDisguise(OfflinePlayer offlinePlayer) {
        return this.disguiseMap.getDisguise(offlinePlayer);
    }

    public int getNumberOfDisguisedPlayers() {
        int i = 0;
        for (Player player : Reflection.getOnlinePlayers()) {
            if (!this.isDisguised((OfflinePlayer)player)) continue;
            ++i;
        }
        return i;
    }

    public Set<OfflinePlayer> getDisguisedPlayers() {
        Set<?> origin = this.disguiseMap.getDisguisedPlayers();
        HashSet<OfflinePlayer> destination = new HashSet<OfflinePlayer>();
        try {
            for (Object offlinePlayer : origin) {
                destination.add(offlinePlayer instanceof UUID ? (OfflinePlayer)Reflection.Bukkit_getOfflinePlayer.invoke(null, offlinePlayer) : Bukkit.getOfflinePlayer((String)((String)offlinePlayer)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destination;
    }

    public Map<?, Disguise> getDisguises() {
        return this.disguiseMap.getMap();
    }

    public void updateDisguises(Map<?, Disguise> map) {
        this.disguiseMap = DisguiseMap.fromMap(map);
    }

    public void resendPackets(Player player) {
        for (Player observer : Reflection.getOnlinePlayers()) {
            if (observer == player) continue;
            observer.hidePlayer(player);
        }
        for (Player observer : Reflection.getOnlinePlayers()) {
            if (observer == player) continue;
            observer.showPlayer(player);
        }
    }

    public void resendPackets() {
        for (OfflinePlayer offlinePlayer : this.getDisguisedPlayers()) {
            if (!offlinePlayer.isOnline()) continue;
            Player player = offlinePlayer.getPlayer();
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.hidePlayer(player);
            }
            for (Player observer : Reflection.getOnlinePlayers()) {
                if (observer == player) continue;
                observer.showPlayer(player);
            }
        }
    }
}

