/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise;

import de.robingrether.idisguise.EventListener;
import de.robingrether.idisguise.api.DisguiseAPI;
import de.robingrether.idisguise.api.DisguiseEvent;
import de.robingrether.idisguise.api.OfflinePlayerDisguiseEvent;
import de.robingrether.idisguise.api.OfflinePlayerUndisguiseEvent;
import de.robingrether.idisguise.api.UndisguiseEvent;
import de.robingrether.idisguise.disguise.AgeableDisguise;
import de.robingrether.idisguise.disguise.CreeperDisguise;
import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.EndermanDisguise;
import de.robingrether.idisguise.disguise.FallingBlockDisguise;
import de.robingrether.idisguise.disguise.OcelotDisguise;
import de.robingrether.idisguise.disguise.OutdatedServerException;
import de.robingrether.idisguise.disguise.PigDisguise;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.disguise.RabbitDisguise;
import de.robingrether.idisguise.disguise.SheepDisguise;
import de.robingrether.idisguise.disguise.SizedDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import de.robingrether.idisguise.disguise.VillagerDisguise;
import de.robingrether.idisguise.disguise.WolfDisguise;
import de.robingrether.idisguise.io.Configuration;
import de.robingrether.idisguise.io.Language;
import de.robingrether.idisguise.io.SLAPI;
import de.robingrether.idisguise.io.UpdateCheck;
import de.robingrether.idisguise.io.bstats.Metrics;
import de.robingrether.idisguise.management.ChannelInjector;
import de.robingrether.idisguise.management.DisguiseManager;
import de.robingrether.idisguise.management.GhostFactory;
import de.robingrether.idisguise.management.PacketHelper;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.idisguise.management.Reflection;
import de.robingrether.idisguise.management.Sounds;
import de.robingrether.idisguise.management.VersionHelper;
import de.robingrether.util.ObjectUtil;
import de.robingrether.util.RandomUtil;
import de.robingrether.util.StringUtil;
import de.robingrether.util.Validate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class iDisguise
extends JavaPlugin {
    private static iDisguise instance;
    private EventListener listener;
    private Configuration configuration;
    private Language language;
    private Metrics metrics;
    private boolean enabled = false;

    public iDisguise() {
        instance = this;
    }

    public void onEnable() {
        Calendar today;
        if (!VersionHelper.init(false)) {
            this.getLogger().log(Level.SEVERE, String.format("%s is not compatible with your server version!", this.getFullName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.checkDirectory();
        this.listener = new EventListener(this);
        this.configuration = new Configuration(this);
        this.configuration.loadData();
        this.configuration.saveData();
        this.language = new Language(this);
        this.language.loadData();
        this.language.saveData();
        PacketHelper.getInstance().setAttribute(0, this.configuration.NAME_TAG_SHOWN);
        PacketHelper.getInstance().setAttribute(1, this.configuration.MODIFY_PLAYER_LIST_ENTRY);
        Sounds.setEnabled(this.configuration.REPLACE_SOUND_EFFECTS);
        this.metrics = new Metrics(this);
        this.metrics.addCustomChart(new Metrics.SingleLineChart("disguisedPlayers"){

            @Override
            public int getValue() {
                return DisguiseManager.getInstance().getNumberOfDisguisedPlayers();
            }
        });
        this.metrics.addCustomChart(new Metrics.SimplePie("storageType"){

            @Override
            public String getValue() {
                return ((iDisguise)iDisguise.this).configuration.KEEP_DISGUISE_SHUTDOWN ? "file" : "none";
            }
        });
        if (this.configuration.KEEP_DISGUISE_SHUTDOWN) {
            this.loadData();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        if (this.configuration.ENABLE_GHOST_DISGUISE) {
            GhostFactory.getInstance().enable((Plugin)this);
        }
        this.getServer().getServicesManager().register(DisguiseAPI.class, (Object)this.getAPI(), (Plugin)this, ServicePriority.Normal);
        if (this.configuration.UPDATE_CHECK) {
            this.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this, (Runnable)new UpdateCheck(this, (CommandSender)this.getServer().getConsoleSender(), this.configuration.UPDATE_DOWNLOAD), 20L);
        }
        if ((today = Calendar.getInstance()).get(2) == 10 && today.get(5) == 6) {
            this.getLogger().log(Level.INFO, String.format("YAAAY!!! Today is my birthday! I'm %s years old now.", today.get(1) - 2012));
        }
        this.getLogger().log(Level.INFO, String.format("%s enabled!", this.getFullName()));
        this.enabled = true;
        for (Player player : Reflection.getOnlinePlayers()) {
            PlayerHelper.getInstance().addPlayer(player);
            PlayerHelper.getInstance().loadGameProfileAsynchronously(player.getName());
        }
        ChannelInjector.getInstance().injectOnlinePlayers();
        DisguiseManager.getInstance().resendPackets();
    }

    public void onDisable() {
        if (!this.enabled) {
            return;
        }
        if (this.configuration.ENABLE_GHOST_DISGUISE) {
            GhostFactory.getInstance().disable();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.configuration.KEEP_DISGUISE_SHUTDOWN) {
            this.saveData();
        }
        ChannelInjector.getInstance().removeOnlinePlayers();
        this.getLogger().log(Level.INFO, String.format("%s disabled!", this.getFullName()));
        this.enabled = false;
    }

    public void onReload() {
        if (!this.enabled) {
            return;
        }
        if (this.configuration.ENABLE_GHOST_DISGUISE) {
            GhostFactory.getInstance().disable();
        }
        if (this.configuration.KEEP_DISGUISE_SHUTDOWN) {
            this.saveData();
        }
        this.enabled = false;
        this.configuration.loadData();
        this.configuration.saveData();
        this.language.loadData();
        this.language.saveData();
        PacketHelper.getInstance().setAttribute(0, this.configuration.NAME_TAG_SHOWN);
        PacketHelper.getInstance().setAttribute(1, this.configuration.MODIFY_PLAYER_LIST_ENTRY);
        Sounds.setEnabled(this.configuration.REPLACE_SOUND_EFFECTS);
        if (this.configuration.KEEP_DISGUISE_SHUTDOWN) {
            this.loadData();
        }
        if (this.configuration.ENABLE_GHOST_DISGUISE) {
            GhostFactory.getInstance().enable((Plugin)this);
        }
        this.enabled = true;
        DisguiseManager.getInstance().resendPackets();
    }

    /*
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        block98: {
            block96: {
                block102: {
                    block100: {
                        block101: {
                            block99: {
                                block97: {
                                    if (!StringUtil.equalsIgnoreCase((String)command.getName(), (String[])new String[]{"disguise", "odisguise"})) break block96;
                                    if (args.length != 0) break block97;
                                    this.sendHelpMessage(sender, command, alias);
                                    break block98;
                                }
                                if (!args[0].equalsIgnoreCase("reload")) break block99;
                                if (sender.hasPermission("iDisguise.reload")) {
                                    this.onReload();
                                    sender.sendMessage(this.language.RELOAD_COMPLETE);
                                } else {
                                    sender.sendMessage(this.language.NO_PERMISSION);
                                }
                                break block98;
                            }
                            player = null;
                            if (!command.getName().equalsIgnoreCase("disguise")) break block100;
                            if (!(sender instanceof Player)) break block101;
                            player = (Player)sender;
                            disguiseSelf = true;
                            break block102;
                        }
                        sender.sendMessage(this.language.CONSOLE_USE_OTHER_COMMAND);
                        return true;
                    }
                    if (args.length <= 1) ** GOTO lbl42
                    if (sender.hasPermission("iDisguise.others")) {
                        if (this.getServer().getPlayerExact(args[0]) != null) {
                            player = this.getServer().getPlayerExact(args[0]);
                        } else if (this.getServer().matchPlayer(args[0]).size() == 1) {
                            player = (OfflinePlayer)this.getServer().matchPlayer(args[0]).get(0);
                        } else if (this.getServer().getOfflinePlayer(args[0]) != null) {
                            player = this.getServer().getOfflinePlayer(args[0]);
                        } else {
                            sender.sendMessage(this.language.CANNOT_FIND_PLAYER.replace("%player%", args[0]));
                            return true;
                        }
                        disguiseSelf = false;
                        args = Arrays.copyOfRange(args, 1, args.length);
                    } else {
                        sender.sendMessage(this.language.NO_PERMISSION);
                        return true;
lbl42:
                        // 1 sources

                        this.sendHelpMessage(sender, command, alias);
                        return true;
                    }
                }
                if (args[0].equalsIgnoreCase("help")) {
                    this.sendHelpMessage(sender, command, alias);
                } else if (StringUtil.equalsIgnoreCase((String)args[0], (String[])new String[]{"player", "p"}) || this.configuration.ENABLE_GHOST_DISGUISE && StringUtil.equalsIgnoreCase((String)args[0], (String[])new String[]{"ghost", "g"})) {
                    if (args.length < 2) {
                        sender.sendMessage(this.language.WRONG_USAGE_NO_NAME);
                    } else if (!Validate.minecraftUsername((String)args[1].replaceAll("&[0-9a-fk-or]", ""))) {
                        sender.sendMessage(this.language.INVALID_NAME);
                    } else {
                        disguise = new PlayerDisguise(args[1].replaceAll("&[0-9a-fk-or]", ""), args[1].replace('&', '\u00a7'), StringUtil.equalsIgnoreCase((String)args[0], (String[])new String[]{"ghost", "g"}));
                        if (this.hasPermission(sender, disguise)) {
                            if (player.isOnline()) {
                                event = new DisguiseEvent(player.getPlayer(), disguise);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) {
                                    sender.sendMessage(this.language.EVENT_CANCELLED);
                                } else {
                                    DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                    sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_PLAYER_SUCCESS_SELF : this.language.DISGUISE_PLAYER_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()).replace("%name%", disguise.getDisplayName()));
                                }
                            } else {
                                event = new OfflinePlayerDisguiseEvent((OfflinePlayer)player, disguise);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) {
                                    sender.sendMessage(this.language.EVENT_CANCELLED);
                                } else {
                                    DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                    sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_PLAYER_SUCCESS_SELF : this.language.DISGUISE_PLAYER_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()).replace("%name%", disguise.getDisplayName()));
                                }
                            }
                        } else {
                            sender.sendMessage(this.language.NO_PERMISSION);
                        }
                    }
                } else if (args[0].equalsIgnoreCase("random")) {
                    if (sender.hasPermission("iDisguise.random")) {
                        disguise = (RandomUtil.nextBoolean() != false ? DisguiseType.random(DisguiseType.Type.MOB) : DisguiseType.random(DisguiseType.Type.OBJECT)).newInstance();
                        if (player.isOnline()) {
                            event = new DisguiseEvent(player.getPlayer(), disguise);
                            this.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                sender.sendMessage(this.language.EVENT_CANCELLED);
                            } else {
                                DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_SUCCESS_SELF : this.language.DISGUISE_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()));
                            }
                        } else {
                            event = new OfflinePlayerDisguiseEvent((OfflinePlayer)player, disguise);
                            this.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                sender.sendMessage(this.language.EVENT_CANCELLED);
                            } else {
                                DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_SUCCESS_SELF : this.language.DISGUISE_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()));
                            }
                        }
                    } else {
                        sender.sendMessage(this.language.NO_PERMISSION);
                    }
                } else if (StringUtil.equalsIgnoreCase((String)args[0], (String[])new String[]{"status", "state", "stats"})) {
                    if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
                        if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise) {
                            disguise = (PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player);
                            sender.sendMessage((disguiseSelf != false ? this.language.STATUS_PLAYER_SELF : this.language.STATUS_PLAYER_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()).replace("%name%", disguise.getDisplayName()));
                            sender.sendMessage(this.language.STATUS_SUBTYPES.replace("%subtypes%", disguise.toString()));
                        } else {
                            disguise = DisguiseManager.getInstance().getDisguise((OfflinePlayer)player);
                            sender.sendMessage((disguiseSelf != false ? this.language.STATUS_SELF : this.language.STATUS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()));
                            sender.sendMessage(this.language.STATUS_SUBTYPES.replace("%subtypes%", disguise.toString()));
                        }
                    } else {
                        sender.sendMessage((disguiseSelf != false ? this.language.STATUS_NOT_DISGUISED_SELF : this.language.STATUS_NOT_DISGUISED_OTHER).replace("%player%", player.getName()));
                    }
                } else {
                    disguise = DisguiseManager.getInstance().isDisguised((OfflinePlayer)player) != false ? DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).clone() : null;
                    match = false;
                    var9_25 = args;
                    var10_26 = args.length;
                    var11_27 = 0;
                    while (var11_27 < var10_26) {
                        argument = var9_25[var11_27];
                        type = DisguiseType.Matcher.match(argument.toLowerCase(Locale.ENGLISH));
                        if (type != null) {
                            try {
                                disguise = type.newInstance();
                                match = true;
                                break;
                            }
                            catch (OutdatedServerException e) {
                                sender.sendMessage(this.language.OUTDATED_SERVER);
                                return true;
                            }
                            catch (UnsupportedOperationException e) {
                                this.sendHelpMessage(sender, command, alias);
                                return true;
                            }
                        }
                        ++var11_27;
                    }
                    if (disguise != null) {
                        var9_25 = args;
                        var10_26 = args.length;
                        var11_27 = 0;
                        while (var11_27 < var10_26) {
                            argument = var9_25[var11_27];
                            match |= Subtypes.applySubtype(disguise, argument);
                            ++var11_27;
                        }
                    }
                    if (match) {
                        if (this.hasPermission(sender, disguise)) {
                            if (player.isOnline()) {
                                event = new DisguiseEvent(player.getPlayer(), disguise);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) {
                                    sender.sendMessage(this.language.EVENT_CANCELLED);
                                } else {
                                    DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                    sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_SUCCESS_SELF : this.language.DISGUISE_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()));
                                }
                            } else {
                                event = new OfflinePlayerDisguiseEvent((OfflinePlayer)player, disguise);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) {
                                    sender.sendMessage(this.language.EVENT_CANCELLED);
                                } else {
                                    DisguiseManager.getInstance().disguise((OfflinePlayer)player, disguise);
                                    sender.sendMessage((disguiseSelf != false ? this.language.DISGUISE_SUCCESS_SELF : this.language.DISGUISE_SUCCESS_OTHER).replace("%player%", player.getName()).replace("%type%", disguise.getType().toString()));
                                }
                            }
                        } else {
                            sender.sendMessage(this.language.NO_PERMISSION);
                        }
                    } else {
                        this.sendHelpMessage(sender, command, alias);
                    }
                }
                break block98;
            }
            if (command.getName().equalsIgnoreCase("undisguise")) {
                if (args.length == 0) {
                    if (sender instanceof Player) {
                        if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)((Player)sender))) {
                            if (!this.configuration.UNDISGUISE_PERMISSION || sender.hasPermission("iDisguise.undisguise")) {
                                event = new UndisguiseEvent((Player)sender, DisguiseManager.getInstance().getDisguise((OfflinePlayer)((Player)sender)), false);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) {
                                    sender.sendMessage(this.language.EVENT_CANCELLED);
                                } else {
                                    DisguiseManager.getInstance().undisguise((OfflinePlayer)((Player)sender));
                                    sender.sendMessage(this.language.UNDISGUISE_SUCCESS_SELF);
                                }
                            } else {
                                sender.sendMessage(this.language.NO_PERMISSION);
                            }
                        } else {
                            sender.sendMessage(this.language.UNDISGUISE_NOT_DISGUISED_SELF);
                        }
                    } else {
                        sender.sendMessage(this.language.UNDISGUISE_CONSOLE);
                    }
                } else if (args[0].equals("*")) {
                    if (sender.hasPermission("iDisguise.undisguise.all")) {
                        if (args.length > 1 && args[1].equalsIgnoreCase("ignore")) {
                            DisguiseManager.getInstance().undisguiseAll();
                            sender.sendMessage(this.language.UNDISGUISE_SUCCESS_ALL_IGNORE);
                        } else {
                            disguisedPlayers = DisguiseManager.getInstance().getDisguisedPlayers();
                            share = 0;
                            total = disguisedPlayers.size();
                            for (OfflinePlayer player : disguisedPlayers) {
                                if (player.isOnline()) {
                                    event = new UndisguiseEvent(player.getPlayer(), DisguiseManager.getInstance().getDisguise(player), true);
                                    this.getServer().getPluginManager().callEvent((Event)event);
                                    if (event.isCancelled()) continue;
                                    DisguiseManager.getInstance().undisguise(player);
                                    ++share;
                                    continue;
                                }
                                event = new OfflinePlayerUndisguiseEvent(player, DisguiseManager.getInstance().getDisguise(player), true);
                                this.getServer().getPluginManager().callEvent((Event)event);
                                if (event.isCancelled()) continue;
                                DisguiseManager.getInstance().undisguise(player);
                                ++share;
                            }
                            sender.sendMessage(this.language.UNDISGUISE_SUCCESS_ALL.replace("%share%", Integer.toString(share)).replace("%total%", Integer.toString(total)));
                        }
                    } else {
                        sender.sendMessage(this.language.NO_PERMISSION);
                    }
                } else if (sender.hasPermission("iDisguise.undisguise.others")) {
                    player = null;
                    if (this.getServer().getPlayerExact(args[0]) != null) {
                        player = this.getServer().getPlayerExact(args[0]);
                    } else if (this.getServer().matchPlayer(args[0]).size() == 1) {
                        player = (OfflinePlayer)this.getServer().matchPlayer(args[0]).get(0);
                    } else if (this.getServer().getOfflinePlayer(args[0]) != null) {
                        player = this.getServer().getOfflinePlayer(args[0]);
                    } else {
                        sender.sendMessage(this.language.CANNOT_FIND_PLAYER.replace("%player%", args[0]));
                        return true;
                    }
                    if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
                        if (args.length > 1 && args[1].equalsIgnoreCase("ignore")) {
                            DisguiseManager.getInstance().undisguise((OfflinePlayer)player);
                            sender.sendMessage(this.language.UNDISGUISE_SUCCESS_OTHER.replace("%player%", player.getName()));
                        } else if (player.isOnline()) {
                            event = new UndisguiseEvent(player.getPlayer(), DisguiseManager.getInstance().getDisguise((OfflinePlayer)player), false);
                            this.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                sender.sendMessage(this.language.EVENT_CANCELLED);
                            } else {
                                DisguiseManager.getInstance().undisguise((OfflinePlayer)player);
                                sender.sendMessage(this.language.UNDISGUISE_SUCCESS_OTHER.replace("%player%", player.getName()));
                            }
                        } else {
                            event = new OfflinePlayerUndisguiseEvent((OfflinePlayer)player, DisguiseManager.getInstance().getDisguise((OfflinePlayer)player), false);
                            this.getServer().getPluginManager().callEvent((Event)event);
                            if (event.isCancelled()) {
                                sender.sendMessage(this.language.EVENT_CANCELLED);
                            } else {
                                DisguiseManager.getInstance().undisguise((OfflinePlayer)player);
                                sender.sendMessage(this.language.UNDISGUISE_SUCCESS_OTHER.replace("%player%", player.getName()));
                            }
                        }
                    } else {
                        sender.sendMessage(this.language.UNDISGUISE_NOT_DISGUISED_OTHER.replace("%player%", player.getName()));
                    }
                } else {
                    sender.sendMessage(this.language.NO_PERMISSION);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        DisguiseType type;
        int n;
        String[] stringArray;
        Object disguise;
        DisguiseType type2;
        int n2;
        Player player2;
        ArrayList<String> completions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("disguise")) {
            if (sender instanceof Player) {
                player2 = (Player)sender;
                if (args.length < 2) {
                    completions.addAll(Arrays.asList("help", "player", "status"));
                    if (this.configuration.ENABLE_GHOST_DISGUISE) {
                        completions.add("ghost");
                    }
                    if (sender.hasPermission("iDisguise.random")) {
                        completions.add("random");
                    }
                    if (sender.hasPermission("iDisguise.reload")) {
                        completions.add("reload");
                    }
                    DisguiseType[] disguiseTypeArray = DisguiseType.values();
                    n2 = disguiseTypeArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        type2 = disguiseTypeArray[n3];
                        if (type2.isAvailable() && !type2.isPlayer()) {
                            completions.add(type2.getDefaultCommandArgument());
                        }
                        ++n3;
                    }
                }
                disguise = DisguiseManager.getInstance().isDisguised((OfflinePlayer)player2) ? DisguiseManager.getInstance().getDisguise((OfflinePlayer)player2).clone() : null;
                stringArray = args;
                n = args.length;
                n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    type = DisguiseType.Matcher.match(argument.toLowerCase(Locale.ENGLISH));
                    if (type != null) {
                        try {
                            disguise = type.newInstance();
                            break;
                        }
                        catch (OutdatedServerException outdatedServerException) {
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
                if (disguise != null) {
                    completions.addAll(Subtypes.listSubtypeArguments((Disguise)disguise));
                }
            } else {
                completions.add("reload");
            }
        } else if (command.getName().equalsIgnoreCase("odisguise")) {
            if (args.length < 2) {
                if (sender.hasPermission("iDisguise.reload")) {
                    completions.add("reload");
                }
                if (sender.hasPermission("iDisguise.others")) {
                    for (Player player2 : Reflection.getOnlinePlayers()) {
                        completions.add(player2.getName());
                    }
                }
            } else if (sender.hasPermission("iDisguise.others")) {
                player2 = null;
                if (this.getServer().getPlayerExact(args[0]) != null) {
                    player2 = this.getServer().getPlayerExact(args[0]);
                } else if (this.getServer().matchPlayer(args[0]).size() == 1) {
                    player2 = (OfflinePlayer)this.getServer().matchPlayer(args[0]).get(0);
                } else if (this.getServer().getOfflinePlayer(args[0]) != null) {
                    player2 = this.getServer().getOfflinePlayer(args[0]);
                }
                if (player2 != null) {
                    if (args.length < 3) {
                        completions.addAll(Arrays.asList("help", "player", "status"));
                        if (this.configuration.ENABLE_GHOST_DISGUISE) {
                            completions.add("ghost");
                        }
                        if (sender.hasPermission("iDisguise.random")) {
                            completions.add("random");
                        }
                        DisguiseType[] disguiseTypeArray = DisguiseType.values();
                        n2 = disguiseTypeArray.length;
                        int argument = 0;
                        while (argument < n2) {
                            type2 = disguiseTypeArray[argument];
                            if (!type2.isPlayer() && type2.isAvailable() && this.hasPermission(sender, type2.newInstance())) {
                                completions.add(type2.getDefaultCommandArgument());
                            }
                            ++argument;
                        }
                    }
                    disguise = DisguiseManager.getInstance().isDisguised((OfflinePlayer)player2) ? DisguiseManager.getInstance().getDisguise((OfflinePlayer)player2).clone() : null;
                    stringArray = args;
                    n = args.length;
                    n2 = 0;
                    while (n2 < n) {
                        String argument = stringArray[n2];
                        type = DisguiseType.Matcher.match(argument.toLowerCase(Locale.ENGLISH));
                        if (type != null) {
                            try {
                                disguise = type.newInstance();
                                break;
                            }
                            catch (OutdatedServerException outdatedServerException) {
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                    if (disguise != null) {
                        completions.addAll(Subtypes.listSubtypeArguments((Disguise)disguise));
                    }
                }
            }
        } else if (command.getName().equalsIgnoreCase("undisguise")) {
            if (args.length < 2) {
                if (sender.hasPermission("iDisguise.undisguise.all")) {
                    completions.add("*");
                }
                if (sender.hasPermission("iDisguise.undisguise.others")) {
                    for (Player player2 : Reflection.getOnlinePlayers()) {
                        if (!DisguiseManager.getInstance().isDisguised((OfflinePlayer)player2)) continue;
                        completions.add(player2.getName());
                    }
                }
            } else {
                completions.add("ignore");
            }
        }
        if (args.length > 0) {
            int i = 0;
            while (i < completions.size()) {
                if (!StringUtil.startsWithIgnoreCase((String)((String)completions.get(i)), (String)args[args.length - 1])) {
                    completions.remove(i);
                    --i;
                }
                ++i;
            }
        }
        return completions;
    }

    private void sendHelpMessage(CommandSender sender, Command command, String alias) {
        if (!sender.hasPermission("iDisguise.help")) {
            sender.sendMessage(this.language.NO_PERMISSION);
            return;
        }
        alias = alias.toLowerCase(Locale.ENGLISH);
        boolean self = command.getName().equalsIgnoreCase("disguise");
        String disguiseCommand = "/" + (self ? alias : String.valueOf(alias) + " <player>");
        String undisguiseCommand = "/" + alias.replaceAll("o?disguise$", "undisguise").replaceAll("o?dis$", "undis").replaceAll("o?d$", "ud");
        sender.sendMessage(this.language.HELP_INFO.replace("%name%", "iDisguise").replace("%version%", this.getVersion()));
        Calendar today = Calendar.getInstance();
        if (today.get(2) == 10 && today.get(5) == 6) {
            sender.sendMessage(this.language.EASTER_EGG_BIRTHDAY.replace("%age%", Integer.toString(today.get(1) - 2012)));
        }
        sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " help").replace("%description%", this.language.HELP_HELP));
        sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " player <name>").replace("%description%", self ? this.language.HELP_PLAYER_SELF : this.language.HELP_PLAYER_OTHER));
        if (this.configuration.ENABLE_GHOST_DISGUISE) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " ghost <name>").replace("%description%", self ? this.language.HELP_GHOST_SELF : this.language.HELP_GHOST_OTHER));
        }
        if (sender.hasPermission("iDisguise.random")) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " random").replace("%description%", self ? this.language.HELP_RANDOM_SELF : this.language.HELP_RANDOM_OTHER));
        }
        if (sender.hasPermission("iDisguise.reload")) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", "/" + alias + " reload").replace("%description%", this.language.HELP_RELOAD));
        }
        sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " status").replace("%description%", self ? this.language.HELP_STATUS_SELF : this.language.HELP_STATUS_OTHER));
        if (self) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", undisguiseCommand).replace("%description%", this.language.HELP_UNDISGUISE_SELF));
        }
        if (sender.hasPermission("iDisguise.undisguise.all")) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(undisguiseCommand) + " * [ignore]").replace("%description%", this.language.HELP_UNDISGUISE_ALL));
        }
        if (sender.hasPermission("iDisguise.undisguise.others")) {
            sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(undisguiseCommand) + " <player> [ignore]").replace("%description%", this.language.HELP_UNDISGUISE_OTHER));
        }
        sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " [subtype] <type> [subtype]").replace("%description%", self ? this.language.HELP_DISGUISE_SELF : this.language.HELP_DISGUISE_OTHER));
        sender.sendMessage(this.language.HELP_BASE.replace("%command%", String.valueOf(disguiseCommand) + " <subtype>").replace("%description%", this.language.HELP_SUBTYPE));
        StringBuilder builder = new StringBuilder();
        String color = ChatColor.getLastColors((String)this.language.HELP_TYPES);
        DisguiseType[] disguiseTypeArray = DisguiseType.values();
        int n = disguiseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisguiseType type = disguiseTypeArray[n2];
            if (!type.isPlayer()) {
                String format;
                String string = !type.isAvailable() ? this.language.HELP_TYPES_NOT_SUPPORTED : (format = this.hasPermission(sender, type) ? this.language.HELP_TYPES_AVAILABLE : this.language.HELP_TYPES_NO_PERMISSION);
                if (format.contains("%type%")) {
                    builder.append(format.replace("%type%", type.getDefaultCommandArgument()));
                    builder.append(String.valueOf(color) + ", ");
                }
            }
            ++n2;
        }
        sender.sendMessage(this.language.HELP_TYPES.replace("%types%", builder.substring(0, builder.length() - 2)));
    }

    private boolean hasPermission(CommandSender sender, DisguiseType type) {
        switch (type) {
            case BAT: {
                return sender.hasPermission("iDisguise.mob.bat");
            }
            case BLAZE: {
                return sender.hasPermission("iDisguise.mob.blaze");
            }
            case CAVE_SPIDER: {
                return sender.hasPermission("iDisguise.mob.cave_spider");
            }
            case CHICKEN: {
                return sender.hasPermission("iDisguise.mob.chicken");
            }
            case COW: {
                return sender.hasPermission("iDisguise.mob.cow");
            }
            case CREEPER: {
                return sender.hasPermission("iDisguise.mob.creeper");
            }
            case DONKEY: {
                return sender.hasPermission("iDisguise.mob.donkey");
            }
            case ELDER_GUARDIAN: {
                return sender.hasPermission("iDisguise.mob.elder_guardian");
            }
            case ENDER_DRAGON: {
                return sender.hasPermission("iDisguise.mob.ender_dragon");
            }
            case ENDERMAN: {
                return sender.hasPermission("iDisguise.mob.enderman");
            }
            case ENDERMITE: {
                return sender.hasPermission("iDisguise.mob.endermite");
            }
            case EVOKER: {
                return sender.hasPermission("iDisguise.mob.evoker");
            }
            case GHAST: {
                return sender.hasPermission("iDisguise.mob.ghast");
            }
            case GIANT: {
                return sender.hasPermission("iDisguise.mob.giant");
            }
            case GUARDIAN: {
                return sender.hasPermission("iDisguise.mob.guardian");
            }
            case HORSE: {
                return sender.hasPermission("iDisguise.mob.horse");
            }
            case HUSK: {
                return sender.hasPermission("iDisguise.mob.husk");
            }
            case IRON_GOLEM: {
                return sender.hasPermission("iDisguise.mob.iron_golem");
            }
            case LLAMA: {
                return sender.hasPermission("iDisguise.mob.llama");
            }
            case MAGMA_CUBE: {
                return sender.hasPermission("iDisguise.mob.magma_cube");
            }
            case MULE: {
                return sender.hasPermission("iDisguise.mob.mule");
            }
            case MUSHROOM_COW: {
                return sender.hasPermission("iDisguise.mob.mushroom_cow");
            }
            case OCELOT: {
                return sender.hasPermission("iDisguise.mob.ocelot");
            }
            case PIG: {
                return sender.hasPermission("iDisguise.mob.pig");
            }
            case PIG_ZOMBIE: {
                return sender.hasPermission("iDisguise.mob.pig_zombie");
            }
            case POLAR_BEAR: {
                return sender.hasPermission("iDisguise.mob.polar_bear");
            }
            case RABBIT: {
                return sender.hasPermission("iDisguise.mob.rabbit");
            }
            case SHEEP: {
                return sender.hasPermission("iDisguise.mob.sheep");
            }
            case SHULKER: {
                return sender.hasPermission("iDisguise.mob.shulker");
            }
            case SILVERFISH: {
                return sender.hasPermission("iDisguise.mob.silverfish");
            }
            case SKELETAL_HORSE: {
                return sender.hasPermission("iDisguise.mob.skeletal_horse");
            }
            case SKELETON: {
                return sender.hasPermission("iDisguise.mob.skeleton");
            }
            case SLIME: {
                return sender.hasPermission("iDisguise.mob.slime");
            }
            case SNOWMAN: {
                return sender.hasPermission("iDisguise.mob.snowman");
            }
            case SPIDER: {
                return sender.hasPermission("iDisguise.mob.spider");
            }
            case SQUID: {
                return sender.hasPermission("iDisguise.mob.squid");
            }
            case STRAY: {
                return sender.hasPermission("iDisguise.mob.stray");
            }
            case UNDEAD_HORSE: {
                return sender.hasPermission("iDisguise.mob.undead_horse");
            }
            case VEX: {
                return sender.hasPermission("iDisguise.mob.vex");
            }
            case VILLAGER: {
                return sender.hasPermission("iDisguise.mob.villager");
            }
            case VINDICATOR: {
                return sender.hasPermission("iDisguise.mob.vindicator");
            }
            case WITCH: {
                return sender.hasPermission("iDisguise.mob.witch");
            }
            case WITHER: {
                return sender.hasPermission("iDisguise.mob.wither");
            }
            case WITHER_SKELETON: {
                return sender.hasPermission("iDisguise.mob.wither_skeleton");
            }
            case WOLF: {
                return sender.hasPermission("iDisguise.mob.wolf");
            }
            case ZOMBIE: {
                return sender.hasPermission("iDisguise.mob.zombie");
            }
            case ZOMBIE_VILLAGER: {
                return sender.hasPermission("iDisguise.mob.zombie_villager");
            }
            case ARMOR_STAND: {
                return sender.hasPermission("iDisguise.object.armor_stand");
            }
            case BOAT: {
                return sender.hasPermission("iDisguise.object.boat");
            }
            case ENDER_CRYSTAL: {
                return sender.hasPermission("iDisguise.object.ender_crystal");
            }
            case FALLING_BLOCK: {
                return sender.hasPermission("iDisguise.object.falling_block");
            }
            case ITEM: {
                return sender.hasPermission("iDisguise.object.item");
            }
            case MINECART: {
                return sender.hasPermission("iDisguise.object.minecart");
            }
        }
        return false;
    }

    private boolean hasPermission(CommandSender sender, Disguise disguise) {
        if (ObjectUtil.equals((Object)((Object)disguise.getVisibility()), (Object[])new Object[]{Disguise.Visibility.ONLY_LIST, Disguise.Visibility.NOT_LIST}) && !sender.hasPermission("iDisguise.visibility.list")) {
            return false;
        }
        if (ObjectUtil.equals((Object)((Object)disguise.getVisibility()), (Object[])new Object[]{Disguise.Visibility.ONLY_PERMISSION, Disguise.Visibility.NOT_PERMISSION}) && !sender.hasPermission("iDisguise.visibility.permission")) {
            return false;
        }
        switch (disguise.getType()) {
            case BAT: {
                return sender.hasPermission("iDisguise.mob.bat");
            }
            case BLAZE: {
                return sender.hasPermission("iDisguise.mob.blaze");
            }
            case CAVE_SPIDER: {
                return sender.hasPermission("iDisguise.mob.cave_spider");
            }
            case CHICKEN: {
                return sender.hasPermission("iDisguise.mob.chicken") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case COW: {
                return sender.hasPermission("iDisguise.mob.cow") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case CREEPER: {
                return sender.hasPermission("iDisguise.mob.creeper") && (!((CreeperDisguise)disguise).isPowered() || sender.hasPermission("iDisguise.mob.creeper.powered"));
            }
            case DONKEY: {
                return sender.hasPermission("iDisguise.mob.donkey") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case ELDER_GUARDIAN: {
                return sender.hasPermission("iDisguise.mob.elder_guardian");
            }
            case ENDER_DRAGON: {
                return sender.hasPermission("iDisguise.mob.ender_dragon");
            }
            case ENDERMAN: {
                return sender.hasPermission("iDisguise.mob.enderman") && (((EndermanDisguise)disguise).getBlockInHand().equals((Object)Material.AIR) || sender.hasPermission("iDisguise.mob.enderman.block"));
            }
            case ENDERMITE: {
                return sender.hasPermission("iDisguise.mob.endermite");
            }
            case EVOKER: {
                return sender.hasPermission("iDisguise.mob.evoker");
            }
            case GHAST: {
                return sender.hasPermission("iDisguise.mob.ghast");
            }
            case GHOST: {
                return !(!sender.hasPermission("iDisguise.ghost") || !sender.hasPermission("iDisguise.player.name.*") && !sender.hasPermission("iDisguise.player.name." + ((PlayerDisguise)disguise).getSkinName()) || !this.isPlayerDisguisePermitted(((PlayerDisguise)disguise).getSkinName()) && !sender.hasPermission("iDisguise.player.prohibited"));
            }
            case GIANT: {
                return sender.hasPermission("iDisguise.mob.giant");
            }
            case GUARDIAN: {
                return sender.hasPermission("iDisguise.mob.guardian");
            }
            case HORSE: {
                return sender.hasPermission("iDisguise.mob.horse") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case HUSK: {
                return sender.hasPermission("iDisguise.mob.husk") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case IRON_GOLEM: {
                return sender.hasPermission("iDisguise.mob.iron_golem");
            }
            case LLAMA: {
                return sender.hasPermission("iDisguise.mob.llama") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case MAGMA_CUBE: {
                return sender.hasPermission("iDisguise.mob.magma_cube") && (((SizedDisguise)disguise).getSize() < 5 || sender.hasPermission("iDisguise.mob.magma_cube.giant"));
            }
            case MULE: {
                return sender.hasPermission("iDisguise.mob.mule") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case MUSHROOM_COW: {
                return sender.hasPermission("iDisguise.mob.mushroom_cow") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case OCELOT: {
                return sender.hasPermission("iDisguise.mob.ocelot") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby")) && sender.hasPermission("iDisguise.mob.ocelot.type." + ((OcelotDisguise)disguise).getCatType().name().toLowerCase(Locale.ENGLISH).replaceAll("_.*", ""));
            }
            case PIG: {
                return !(!sender.hasPermission("iDisguise.mob.pig") || !((AgeableDisguise)disguise).isAdult() && !sender.hasPermission("iDisguise.mob.baby") || ((PigDisguise)disguise).isSaddled() && !sender.hasPermission("iDisguise.mob.pig.saddled"));
            }
            case PIG_ZOMBIE: {
                return sender.hasPermission("iDisguise.mob.pig_zombie") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case PLAYER: {
                return !(!sender.hasPermission("iDisguise.player.name.*") && !sender.hasPermission("iDisguise.player.name." + ((PlayerDisguise)disguise).getSkinName()) || !this.isPlayerDisguisePermitted(((PlayerDisguise)disguise).getSkinName()) && !sender.hasPermission("iDisguise.player.prohibited"));
            }
            case POLAR_BEAR: {
                return sender.hasPermission("iDisguise.mob.polar_bear") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case RABBIT: {
                return sender.hasPermission("iDisguise.mob.rabbit") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby")) && sender.hasPermission("iDisguise.mob.rabbit.type." + ((RabbitDisguise)disguise).getRabbitType().name().toLowerCase(Locale.ENGLISH).replace("_and_", "-").replace("the_killer_bunny", "killer"));
            }
            case SHEEP: {
                return sender.hasPermission("iDisguise.mob.sheep") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby")) && sender.hasPermission("iDisguise.mob.sheep.color." + ((SheepDisguise)disguise).getColor().name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
            }
            case SHULKER: {
                return sender.hasPermission("iDisguise.mob.shulker");
            }
            case SILVERFISH: {
                return sender.hasPermission("iDisguise.mob.silverfish");
            }
            case SKELETAL_HORSE: {
                return sender.hasPermission("iDisguise.mob.skeletal_horse") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case SKELETON: {
                return sender.hasPermission("iDisguise.mob.skeleton");
            }
            case SLIME: {
                return sender.hasPermission("iDisguise.mob.slime") && (((SizedDisguise)disguise).getSize() < 5 || sender.hasPermission("iDisguise.mob.slime.giant"));
            }
            case SNOWMAN: {
                return sender.hasPermission("iDisguise.mob.snowman");
            }
            case SPIDER: {
                return sender.hasPermission("iDisguise.mob.spider");
            }
            case SQUID: {
                return sender.hasPermission("iDisguise.mob.squid");
            }
            case STRAY: {
                return sender.hasPermission("iDisguise.mob.stray");
            }
            case UNDEAD_HORSE: {
                return sender.hasPermission("iDisguise.mob.undead_horse") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case VEX: {
                return sender.hasPermission("iDisguise.mob.vex");
            }
            case VILLAGER: {
                return sender.hasPermission("iDisguise.mob.villager") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby")) && sender.hasPermission("iDisguise.mob.villager.profession." + ((VillagerDisguise)disguise).getProfession().name().toLowerCase(Locale.ENGLISH));
            }
            case VINDICATOR: {
                return sender.hasPermission("iDisguise.mob.vindicator");
            }
            case WITCH: {
                return sender.hasPermission("iDisguise.mob.witch");
            }
            case WITHER: {
                return sender.hasPermission("iDisguise.mob.wither");
            }
            case WITHER_SKELETON: {
                return sender.hasPermission("iDisguise.mob.wither_skeleton");
            }
            case WOLF: {
                return !(!sender.hasPermission("iDisguise.mob.wolf") || !((AgeableDisguise)disguise).isAdult() && !sender.hasPermission("iDisguise.mob.baby") || !sender.hasPermission("iDisguise.mob.wolf.collar." + ((WolfDisguise)disguise).getCollarColor().name().toLowerCase(Locale.ENGLISH).replace('_', '-')) || ((WolfDisguise)disguise).isTamed() && !sender.hasPermission("iDisguise.mob.wolf.tamed") || ((WolfDisguise)disguise).isAngry() && !sender.hasPermission("iDisguise.mob.wolf.angry"));
            }
            case ZOMBIE: {
                return sender.hasPermission("iDisguise.mob.zombie") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case ZOMBIE_VILLAGER: {
                return sender.hasPermission("iDisguise.mob.zombie_villager") && (((AgeableDisguise)disguise).isAdult() || sender.hasPermission("iDisguise.mob.baby"));
            }
            case ARMOR_STAND: {
                return sender.hasPermission("iDisguise.object.armor_stand");
            }
            case BOAT: {
                return sender.hasPermission("iDisguise.object.boat");
            }
            case ENDER_CRYSTAL: {
                return sender.hasPermission("iDisguise.object.ender_crystal");
            }
            case FALLING_BLOCK: {
                return sender.hasPermission("iDisguise.object.falling_block") && (sender.hasPermission("iDisguise.object.falling_block.material.*") || sender.hasPermission("iDisguise.object.falling_block.material." + ((FallingBlockDisguise)disguise).getMaterial().name().toLowerCase(Locale.ENGLISH).replace('_', '-')));
            }
            case ITEM: {
                return sender.hasPermission("iDisguise.object.item");
            }
            case MINECART: {
                return sender.hasPermission("iDisguise.object.minecart");
            }
        }
        return false;
    }

    private void checkDirectory() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
    }

    private void loadData() {
        File dataFile = new File(this.getDataFolder(), "disguises.dat");
        File oldDataFile = new File(this.getDataFolder(), "data.bin");
        if (dataFile.exists()) {
            DisguiseManager.getInstance().updateDisguises(SLAPI.loadMap(dataFile));
        } else if (oldDataFile.exists()) {
            Object map = SLAPI.load(oldDataFile);
            if (map instanceof Map) {
                DisguiseManager.getInstance().updateDisguises((Map)map);
            }
            oldDataFile.delete();
        }
    }

    private void saveData() {
        File dataFile = new File(this.getDataFolder(), "disguises.dat");
        SLAPI.saveMap(DisguiseManager.getInstance().getDisguises(), dataFile);
    }

    public DisguiseAPI getAPI() {
        return new DisguiseAPI(){

            @Override
            @Deprecated
            public void disguiseToAll(Player player, Disguise disguise) {
                this.disguise((OfflinePlayer)player, disguise, false);
            }

            @Override
            @Deprecated
            public void undisguiseToAll(Player player) {
                this.undisguise((OfflinePlayer)player, false);
            }

            @Override
            public boolean disguise(OfflinePlayer player, Disguise disguise) {
                return this.disguise(player, disguise, true);
            }

            @Override
            public boolean disguise(OfflinePlayer player, Disguise disguise, boolean fireEvent) {
                if (fireEvent) {
                    if (player.isOnline()) {
                        DisguiseEvent event = new DisguiseEvent(player.getPlayer(), disguise);
                        iDisguise.this.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return false;
                        }
                        DisguiseManager.getInstance().disguise(player, disguise);
                        return true;
                    }
                    OfflinePlayerDisguiseEvent event = new OfflinePlayerDisguiseEvent(player, disguise);
                    iDisguise.this.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    DisguiseManager.getInstance().disguise(player, disguise);
                    return true;
                }
                DisguiseManager.getInstance().disguise(player, disguise);
                return true;
            }

            @Override
            public boolean undisguise(OfflinePlayer player) {
                return this.undisguise(player, true);
            }

            @Override
            public boolean undisguise(OfflinePlayer player, boolean fireEvent) {
                if (!this.isDisguised(player)) {
                    return false;
                }
                if (fireEvent) {
                    if (player.isOnline()) {
                        UndisguiseEvent event = new UndisguiseEvent(player.getPlayer(), this.getDisguise(player), false);
                        iDisguise.this.getServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return false;
                        }
                        DisguiseManager.getInstance().undisguise(player);
                        return true;
                    }
                    OfflinePlayerUndisguiseEvent event = new OfflinePlayerUndisguiseEvent(player, this.getDisguise(player), false);
                    iDisguise.this.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    DisguiseManager.getInstance().undisguise(player);
                    return true;
                }
                DisguiseManager.getInstance().undisguise(player);
                return true;
            }

            @Override
            public void undisguiseAll() {
                DisguiseManager.getInstance().undisguiseAll();
            }

            @Override
            @Deprecated
            public boolean isDisguised(Player player) {
                return this.isDisguised((OfflinePlayer)player);
            }

            @Override
            public boolean isDisguised(OfflinePlayer player) {
                return DisguiseManager.getInstance().isDisguised(player);
            }

            @Override
            public boolean isDisguisedTo(OfflinePlayer player, Player observer) {
                return DisguiseManager.getInstance().isDisguisedTo(player, observer);
            }

            @Override
            @Deprecated
            public Disguise getDisguise(Player player) {
                return this.getDisguise((OfflinePlayer)player);
            }

            @Override
            public Disguise getDisguise(OfflinePlayer player) {
                return DisguiseManager.getInstance().getDisguise(player).clone();
            }

            @Override
            @Deprecated
            public int getOnlineDisguiseCount() {
                return this.getNumberOfDisguisedPlayers();
            }

            @Override
            public int getNumberOfDisguisedPlayers() {
                return DisguiseManager.getInstance().getNumberOfDisguisedPlayers();
            }

            @Override
            public Sounds getSoundsForEntity(DisguiseType type) {
                return Sounds.getSoundsForEntity(type);
            }

            @Override
            public boolean setSoundsForEntity(DisguiseType type, Sounds sounds) {
                return Sounds.setSoundsForEntity(type, sounds);
            }

            @Override
            public boolean isSoundsEnabled() {
                return Sounds.isEnabled();
            }

            @Override
            public void setSoundsEnabled(boolean enabled) {
                Sounds.setEnabled(enabled);
            }

            @Override
            public boolean hasPermission(Player player, DisguiseType type) {
                return this.hasPermission(player, type);
            }

            @Override
            public boolean hasPermission(Player player, Disguise disguise) {
                return iDisguise.this.hasPermission((CommandSender)player, disguise);
            }
        };
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public String getFullName() {
        return "iDisguise " + this.getVersion();
    }

    public File getPluginFile() {
        return this.getFile();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isPlayerDisguisePermitted(String name) {
        return !this.getConfiguration().RESTRICTED_PLAYER_NAMES.contains(name);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public static iDisguise getInstance() {
        return instance;
    }
}

