/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.management.VersionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.ChatColor;

public class Subtypes {
    private static Map<Class<? extends Disguise>, Map<String, Subtype>> registeredClasses = new ConcurrentHashMap<Class<? extends Disguise>, Map<String, Subtype>>();
    private static Map<Class<? extends Disguise>, Map<String, ParameterizedSubtype>> registeredClasses2 = new ConcurrentHashMap<Class<? extends Disguise>, Map<String, ParameterizedSubtype>>();

    public static void registerSubtype(Class<? extends Disguise> disguiseClass, String methodName, Object parameter, String argument) {
        block3: {
            if (!registeredClasses.containsKey(disguiseClass)) {
                registeredClasses.put(disguiseClass, new LinkedHashMap());
            }
            Map<String, Subtype> registeredSubtypes = registeredClasses.get(disguiseClass);
            try {
                registeredSubtypes.put(argument, new Subtype(disguiseClass, methodName, parameter));
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block3;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot register the given subtype: " + disguiseClass.getSimpleName() + "/" + argument, e);
            }
        }
    }

    public static void registerSubtype(Class<? extends Disguise> disguiseClass, String methodName, boolean parameter, String argument) {
        block3: {
            if (!registeredClasses.containsKey(disguiseClass)) {
                registeredClasses.put(disguiseClass, new LinkedHashMap());
            }
            Map<String, Subtype> registeredSubtypes = registeredClasses.get(disguiseClass);
            try {
                registeredSubtypes.put(argument, new Subtype((Class)disguiseClass, methodName, parameter));
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block3;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot register the given subtype: " + disguiseClass.getSimpleName() + "/" + argument, e);
            }
        }
    }

    public static void registerSubtype(Class<? extends Disguise> disguiseClass, String methodName, int parameter, String argument) {
        block3: {
            if (!registeredClasses.containsKey(disguiseClass)) {
                registeredClasses.put(disguiseClass, new LinkedHashMap());
            }
            Map<String, Subtype> registeredSubtypes = registeredClasses.get(disguiseClass);
            try {
                registeredSubtypes.put(argument, new Subtype((Class)disguiseClass, methodName, parameter));
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block3;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot register the given subtype: " + disguiseClass.getSimpleName() + "/" + argument, e);
            }
        }
    }

    public static void registerParameterizedSubtype(Class<? extends Disguise> disguiseClass, String methodName, String argument, Class<?> parameterType) {
        block3: {
            if (!registeredClasses2.containsKey(disguiseClass)) {
                registeredClasses2.put(disguiseClass, new LinkedHashMap());
            }
            Map<String, ParameterizedSubtype> registeredSubtypes = registeredClasses2.get(disguiseClass);
            try {
                registeredSubtypes.put(argument, new ParameterizedSubtype(disguiseClass, methodName, parameterType));
            }
            catch (Exception e) {
                if (!VersionHelper.debug()) break block3;
                iDisguise.getInstance().getLogger().log(Level.SEVERE, "Cannot register the given subtype: " + disguiseClass.getSimpleName() + "/" + argument, e);
            }
        }
    }

    public static boolean applySubtype(Disguise disguise, String argument) {
        if (argument.contains(";")) {
            return false;
        }
        Class<?> clazz = disguise.getClass();
        ArrayList classes = new ArrayList();
        while (clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        if (argument.contains("=")) {
            String string = ChatColor.translateAlternateColorCodes((char)'&', (String)argument.substring(argument.indexOf("=") + 1).replace("\\s", " "));
            argument = argument.substring(0, argument.indexOf("="));
            for (Class clazz2 : classes) {
                ParameterizedSubtype subtype;
                Map<String, ParameterizedSubtype> registeredSubtypes = registeredClasses2.get(clazz2);
                if (registeredSubtypes == null || (subtype = registeredSubtypes.get(argument.toLowerCase(Locale.ENGLISH).replace('_', '-'))) == null) continue;
                try {
                    subtype.apply(disguise, string);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        } else {
            for (Class clazz3 : classes) {
                Subtype subtype;
                Map<String, Subtype> registeredSubtypes = registeredClasses.get(clazz3);
                if (registeredSubtypes == null || (subtype = registeredSubtypes.get(argument.toLowerCase(Locale.ENGLISH).replace('_', '-'))) == null) continue;
                try {
                    subtype.apply(disguise);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public static List<String> listSubtypeArguments(Disguise disguise) {
        Class<?> clazz = disguise.getClass();
        Stack classes = new Stack();
        while (clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<String> subtypeArguments = new ArrayList<String>();
        while (!classes.isEmpty()) {
            Class disguiseClass = (Class)classes.pop();
            if (registeredClasses.containsKey(disguiseClass)) {
                subtypeArguments.addAll(registeredClasses.get(disguiseClass).keySet());
            }
            if (!registeredClasses2.containsKey(disguiseClass)) continue;
            for (String subtypeArgument : registeredClasses2.get(disguiseClass).keySet()) {
                subtypeArguments.add(String.valueOf(subtypeArgument) + "=");
            }
        }
        return subtypeArguments;
    }

    private static class ParameterizedSubtype {
        private Method method;
        private Class<?> parameterType;

        private ParameterizedSubtype(Class<? extends Disguise> disguiseClass, String methodName, Class<?> parameterType) throws NoSuchMethodException {
            this.method = disguiseClass.getDeclaredMethod(methodName, parameterType);
            this.parameterType = parameterType;
        }

        private void apply(Disguise disguise, String parameter) throws InvocationTargetException, IllegalAccessException {
            if (this.parameterType == Integer.TYPE) {
                this.method.invoke((Object)disguise, Integer.parseInt(parameter));
            } else if (this.parameterType == String.class) {
                this.method.invoke((Object)disguise, parameter);
            } else if (this.parameterType == String[].class) {
                this.method.invoke((Object)disguise, new Object[]{parameter.split(",")});
            } else if (Enum.class.isAssignableFrom(this.parameterType)) {
                this.method.invoke((Object)disguise, Enum.valueOf(this.parameterType, parameter.toUpperCase(Locale.ENGLISH).replace('-', '_')));
            }
        }
    }

    private static class Subtype {
        private Method method;
        private Object parameter;

        private Subtype(Class<? extends Disguise> disguiseClass, String methodName, Object parameter) throws NoSuchMethodException {
            this.method = disguiseClass.getDeclaredMethod(methodName, parameter.getClass());
            this.parameter = parameter;
        }

        private Subtype(Class<? extends Disguise> disguiseClass, String methodName, boolean parameter) throws NoSuchMethodException {
            this.method = disguiseClass.getDeclaredMethod(methodName, Boolean.TYPE);
            this.parameter = parameter;
        }

        private Subtype(Class<? extends Disguise> disguiseClass, String methodName, int parameter) throws NoSuchMethodException {
            this.method = disguiseClass.getDeclaredMethod(methodName, Integer.TYPE);
            this.parameter = parameter;
        }

        private void apply(Disguise disguise) throws InvocationTargetException, IllegalAccessException {
            this.method.invoke((Object)disguise, this.parameter);
        }
    }
}

