/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.util.Validate;
import java.util.Locale;

public class PlayerDisguise
extends Disguise {
    private static final long serialVersionUID = -1352667720037212662L;
    private final String skinName;
    private String displayName;

    public PlayerDisguise(String skinName) {
        this(skinName, false);
    }

    public PlayerDisguise(String skinName, boolean ghost) {
        this(skinName, skinName, ghost);
    }

    public PlayerDisguise(String skinName, String displayName, boolean ghost) {
        super(ghost ? DisguiseType.GHOST : DisguiseType.PLAYER);
        if (!Validate.minecraftUsername((String)skinName)) {
            throw new IllegalArgumentException("The given skin name is invalid!");
        }
        this.skinName = skinName.toLowerCase(Locale.ENGLISH);
        this.displayName = displayName;
        PlayerHelper.getInstance().loadGameProfileAsynchronously(this.skinName);
    }

    @Deprecated
    public String getName() {
        return this.skinName;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isGhost() {
        return this.type == DisguiseType.GHOST;
    }

    @Override
    public String toString() {
        return String.format("%s; %s; %s", super.toString(), this.skinName, this.displayName);
    }
}

