/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.Subtypes;

public class ObjectDisguise
extends Disguise {
    private static final long serialVersionUID = 7999903708957650848L;
    private final int typeId;
    protected String customName = "";

    static {
        Subtypes.registerParameterizedSubtype(ObjectDisguise.class, "setCustomName", "custom-name", String.class);
    }

    public ObjectDisguise(DisguiseType type) {
        super(type);
        if (!type.isObject()) {
            throw new IllegalArgumentException("DisguiseType must be an object");
        }
        this.typeId = ObjectDisguise.getTypeId(type);
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        if (customName == null) {
            customName = "";
        } else if (customName.length() > 64) {
            customName = customName.substring(0, 64);
        }
        this.customName = customName;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; custom-name=" + this.customName;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public static int getTypeId(DisguiseType type) {
        if (!type.isObject()) {
            throw new IllegalArgumentException("DisguiseType must be an object");
        }
        switch (type) {
            case ARMOR_STAND: {
                return 78;
            }
            case BOAT: {
                return 1;
            }
            case ENDER_CRYSTAL: {
                return 51;
            }
            case FALLING_BLOCK: {
                return 70;
            }
            case ITEM: {
                return 2;
            }
            case MINECART: {
                return 10;
            }
        }
        return 0;
    }
}

