/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.ObjectDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import java.util.Locale;
import org.bukkit.Material;

public class MinecartDisguise
extends ObjectDisguise {
    private static final long serialVersionUID = -2064613105255090886L;
    private Material displayedBlock;
    private int displayedBlockData;

    static {
        Subtypes.registerParameterizedSubtype(MinecartDisguise.class, "setDisplayedBlock", "block", Material.class);
        Subtypes.registerParameterizedSubtype(MinecartDisguise.class, "setDisplayedBlockData", "block-data", Integer.TYPE);
    }

    public MinecartDisguise() {
        this(Material.AIR);
    }

    public MinecartDisguise(Material displayedBlock) {
        this(displayedBlock, 0);
    }

    public MinecartDisguise(Material displayedBlock, int displayedBlockData) {
        super(DisguiseType.MINECART);
        if (displayedBlock == null) {
            displayedBlock = Material.AIR;
        }
        if (!displayedBlock.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        this.displayedBlock = displayedBlock;
        if (displayedBlockData < 0) {
            throw new IllegalArgumentException("Data must be positive");
        }
        this.displayedBlockData = displayedBlockData;
    }

    public Material getDisplayedBlock() {
        return this.displayedBlock;
    }

    public void setDisplayedBlock(Material displayedBlock) {
        if (!displayedBlock.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        this.displayedBlock = displayedBlock;
        this.displayedBlockData = 0;
    }

    public int getDisplayedBlockData() {
        return this.displayedBlockData;
    }

    public void setDisplayedBlockData(int displayedBlockData) {
        if (displayedBlockData < 0) {
            throw new IllegalArgumentException("Data must be positive");
        }
        this.displayedBlockData = displayedBlockData;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; block=" + this.displayedBlock.name().toLowerCase(Locale.ENGLISH).replace('_', '-') + "; block-data=" + this.displayedBlockData;
    }
}

