/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.AgeableDisguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.Subtypes;
import java.util.Locale;

public class LlamaDisguise
extends AgeableDisguise {
    private static final long serialVersionUID = -6219216156842365747L;
    private Color color;
    private SaddleColor saddle;
    private boolean hasChest;

    static {
        Enum[] enumArray = Color.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = enumArray[n2];
            Subtypes.registerSubtype(LlamaDisguise.class, "setColor", (Object)color, color.name().toLowerCase(Locale.ENGLISH));
            ++n2;
        }
        enumArray = SaddleColor.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum saddle = enumArray[n2];
            Subtypes.registerSubtype(LlamaDisguise.class, "setSaddle", saddle, saddle.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
            ++n2;
        }
        Subtypes.registerSubtype(LlamaDisguise.class, "setHasChest", true, "chest");
        Subtypes.registerSubtype(LlamaDisguise.class, "setHasChest", false, "no-chest");
    }

    public LlamaDisguise() {
        this(true, Color.CREAMY, SaddleColor.NOT_SADDLED, false);
    }

    public LlamaDisguise(boolean adult, Color color, SaddleColor saddle, boolean hasChest) {
        super(DisguiseType.LLAMA, adult);
        this.color = color;
        this.saddle = saddle;
        this.hasChest = hasChest;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public SaddleColor getSaddle() {
        return this.saddle;
    }

    public void setSaddle(SaddleColor saddle) {
        this.saddle = saddle;
    }

    public boolean hasChest() {
        return this.hasChest;
    }

    public void setHasChest(boolean hasChest) {
        this.hasChest = hasChest;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; " + this.color.name().toLowerCase(Locale.ENGLISH) + "; " + this.saddle.name().toLowerCase(Locale.ENGLISH).replace('_', '-') + "; " + (this.hasChest ? "chest" : "no-chest");
    }

    public static enum Color {
        CREAMY,
        WHITE,
        BROWN,
        GRAY;

    }

    public static enum SaddleColor {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        SILVER,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK,
        NOT_SADDLED;

    }
}

