/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.ObjectDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemDisguise
extends ObjectDisguise {
    private static final long serialVersionUID = -4607689524782164382L;
    private ItemStack itemStack;

    static {
        Subtypes.registerParameterizedSubtype(ItemDisguise.class, "setMaterial", "material", Material.class);
        Subtypes.registerParameterizedSubtype(ItemDisguise.class, "setData", "material-data", Integer.TYPE);
        Subtypes.registerParameterizedSubtype(ItemDisguise.class, "setAmount", "amount", Integer.TYPE);
    }

    public ItemDisguise() {
        this(new ItemStack(Material.STONE, 1, 0));
    }

    public ItemDisguise(ItemStack itemStack) {
        super(DisguiseType.ITEM);
        if (itemStack == null) {
            throw new IllegalArgumentException("Item stack must not be null");
        }
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("Item stack must not be null");
        }
        this.itemStack = itemStack;
    }

    public Material getMaterial() {
        return this.itemStack.getType();
    }

    public void setMaterial(Material material) {
        this.itemStack.setType(material);
        this.itemStack.setDurability((short)0);
    }

    public int getData() {
        return this.itemStack.getDurability();
    }

    public void setData(int data) {
        this.itemStack.setDurability((short)data);
    }

    public int getAmount() {
        return this.itemStack.getAmount();
    }

    public void setAmount(int amount) {
        if (amount < 1 || amount > 64) {
            throw new IllegalArgumentException("Invalid item stack amount");
        }
        this.itemStack.setAmount(amount);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; material=" + this.itemStack.getType().name().toLowerCase(Locale.ENGLISH).replace('_', '-') + "; material-data=" + this.itemStack.getDurability() + "; amount=" + this.itemStack.getAmount();
    }
}

