/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.AgeableDisguise;
import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.Subtypes;
import de.robingrether.util.ObjectUtil;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class HorseDisguise
extends AgeableDisguise {
    private static final long serialVersionUID = 3739344872858787012L;
    private boolean saddled;
    private Armor armor;

    static {
        Subtypes.registerSubtype(HorseDisguise.class, "setSaddled", true, "saddled");
        Subtypes.registerSubtype(HorseDisguise.class, "setSaddled", false, "not-saddled");
        Armor[] armorArray = Armor.values();
        int n = armorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Armor armor = armorArray[n2];
            Subtypes.registerSubtype(HorseDisguise.class, "setArmor", (Object)armor, armor.name().toLowerCase(Locale.ENGLISH).replace("none", "no-armor"));
            ++n2;
        }
    }

    public HorseDisguise(DisguiseType type) {
        this(type, true, false, Armor.NONE);
    }

    public HorseDisguise(DisguiseType type, boolean adult, boolean saddled, Armor armor) {
        super(type, adult);
        if (!ObjectUtil.equals((Object)((Object)type), (Object[])new Object[]{DisguiseType.DONKEY, DisguiseType.HORSE, DisguiseType.MULE, DisguiseType.SKELETAL_HORSE, DisguiseType.UNDEAD_HORSE})) {
            throw new IllegalArgumentException();
        }
        this.saddled = saddled;
        this.armor = armor;
    }

    public boolean isSaddled() {
        return this.saddled;
    }

    public void setSaddled(boolean saddled) {
        this.saddled = saddled;
    }

    public Armor getArmor() {
        return this.armor;
    }

    public void setArmor(Armor armor) {
        this.armor = armor;
    }

    public int getVariant() {
        switch (this.type) {
            case HORSE: {
                return 0;
            }
            case DONKEY: {
                return 1;
            }
            case MULE: {
                return 2;
            }
            case UNDEAD_HORSE: {
                return 3;
            }
            case SKELETAL_HORSE: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; " + (this.saddled ? "saddled" : "not-saddled") + "; " + this.armor.name().toLowerCase(Locale.ENGLISH).replace("none", "no-armor");
    }

    public static enum Armor {
        IRON("IRON_BARDING"),
        GOLD("GOLD_BARDING"),
        DIAMOND("DIAMOND_BARDING"),
        NONE(null);

        private String item;

        private Armor(String item) {
            this.item = item;
        }

        public ItemStack getItem() {
            return Material.getMaterial((String)this.item) == null ? null : new ItemStack(Material.getMaterial((String)this.item), 1);
        }
    }
}

