/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.ObjectDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import java.util.Locale;
import org.bukkit.Material;

public class FallingBlockDisguise
extends ObjectDisguise {
    private static final long serialVersionUID = -7935017310299797038L;
    private Material material;
    private int data;
    private boolean onlyBlockCoordinates;

    static {
        Subtypes.registerParameterizedSubtype(FallingBlockDisguise.class, "setMaterial", "material", Material.class);
        Subtypes.registerParameterizedSubtype(FallingBlockDisguise.class, "setData", "material-data", Integer.TYPE);
        Subtypes.registerSubtype(FallingBlockDisguise.class, "setOnlyBlockCoordinates", true, "block-coordinates");
        Subtypes.registerSubtype(FallingBlockDisguise.class, "setOnlyBlockCoordinates", false, "all-coordinates");
    }

    public FallingBlockDisguise() {
        this(Material.STONE);
    }

    public FallingBlockDisguise(Material material) {
        this(material, 0);
    }

    public FallingBlockDisguise(Material material, int data) {
        super(DisguiseType.FALLING_BLOCK);
        if (!material.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        if (data < 0) {
            throw new IllegalArgumentException("Data must be positive");
        }
        this.material = material;
        this.data = data;
        this.onlyBlockCoordinates = false;
    }

    public FallingBlockDisguise(Material material, int data, boolean onlyBlockCoordinates) {
        super(DisguiseType.FALLING_BLOCK);
        if (!material.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        if (data < 0) {
            throw new IllegalArgumentException("Data must be positive");
        }
        this.material = material;
        this.data = data;
        this.onlyBlockCoordinates = onlyBlockCoordinates;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (!material.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        this.material = material;
        this.data = 0;
    }

    public int getData() {
        return this.data;
    }

    public void setData(int data) {
        if (data < 0) {
            throw new IllegalArgumentException("Data must be positive");
        }
        this.data = data;
    }

    public boolean onlyBlockCoordinates() {
        return this.onlyBlockCoordinates;
    }

    public void setOnlyBlockCoordinates(boolean onlyBlockCoordinates) {
        this.onlyBlockCoordinates = onlyBlockCoordinates;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; material=" + this.material.name().toLowerCase(Locale.ENGLISH).replace('_', '-') + "; material-data=" + this.data + "; " + (this.onlyBlockCoordinates ? "block-coordinates" : "all-coordinates");
    }
}

