/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.MobDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import java.util.Locale;
import org.bukkit.Material;

public class EndermanDisguise
extends MobDisguise {
    private static final long serialVersionUID = -4717245165572013853L;
    private Material blockInHand;
    private int blockInHandData;

    static {
        Subtypes.registerParameterizedSubtype(EndermanDisguise.class, "setBlockInHand", "block", Material.class);
        Subtypes.registerParameterizedSubtype(EndermanDisguise.class, "setBlockInHandData", "block-data", Integer.TYPE);
    }

    public EndermanDisguise() {
        this(Material.AIR);
    }

    public EndermanDisguise(Material blockInHand) {
        this(blockInHand, 0);
    }

    public EndermanDisguise(Material blockInHand, int blockInHandData) {
        super(DisguiseType.ENDERMAN);
        if (!blockInHand.isBlock()) {
            throw new IllegalArgumentException("Material must be a block!");
        }
        this.blockInHand = blockInHand;
        if (blockInHandData < 0) {
            throw new IllegalArgumentException("Data must be positive!");
        }
        this.blockInHandData = blockInHandData;
    }

    public Material getBlockInHand() {
        return this.blockInHand;
    }

    public void setBlockInHand(Material blockInHand) {
        if (!blockInHand.isBlock()) {
            throw new IllegalArgumentException("Material must be a block!");
        }
        this.blockInHand = blockInHand;
        this.blockInHandData = 0;
    }

    public int getBlockInHandData() {
        return this.blockInHandData;
    }

    public void setBlockInHandData(int blockInHandData) {
        if (blockInHandData < 0) {
            throw new IllegalArgumentException("Data must be positive!");
        }
        this.blockInHandData = blockInHandData;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; block=" + this.blockInHand.name().toLowerCase(Locale.ENGLISH).replace('_', '-') + "; block-data=" + this.blockInHandData;
    }
}

