/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.AgeableDisguise;
import de.robingrether.idisguise.disguise.ArmorStandDisguise;
import de.robingrether.idisguise.disguise.ChestedHorseDisguise;
import de.robingrether.idisguise.disguise.CreeperDisguise;
import de.robingrether.idisguise.disguise.Disguise;
import de.robingrether.idisguise.disguise.EndermanDisguise;
import de.robingrether.idisguise.disguise.FallingBlockDisguise;
import de.robingrether.idisguise.disguise.HorseDisguise;
import de.robingrether.idisguise.disguise.ItemDisguise;
import de.robingrether.idisguise.disguise.LlamaDisguise;
import de.robingrether.idisguise.disguise.MinecartDisguise;
import de.robingrether.idisguise.disguise.MobDisguise;
import de.robingrether.idisguise.disguise.ObjectDisguise;
import de.robingrether.idisguise.disguise.OcelotDisguise;
import de.robingrether.idisguise.disguise.OutdatedServerException;
import de.robingrether.idisguise.disguise.PigDisguise;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.disguise.RabbitDisguise;
import de.robingrether.idisguise.disguise.SheepDisguise;
import de.robingrether.idisguise.disguise.SizedDisguise;
import de.robingrether.idisguise.disguise.StyledHorseDisguise;
import de.robingrether.idisguise.disguise.VillagerDisguise;
import de.robingrether.idisguise.disguise.WolfDisguise;
import de.robingrether.idisguise.disguise.ZombieVillagerDisguise;
import de.robingrether.idisguise.management.VersionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public enum DisguiseType {
    BAT(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityBat", "bat"),
    BLAZE(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityBlaze", "blaze"),
    CAVE_SPIDER(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityCaveSpider", "cave_spider", "cave-spider", "cavespider", "blue_spider", "blue-spider", "bluespider", "cave"),
    CHICKEN(Type.MOB, "v1_7_R3", AgeableDisguise.class, "EntityChicken", "chicken", "chick"),
    COW(Type.MOB, "v1_7_R3", AgeableDisguise.class, "EntityCow", "cow", "cattle", "ox"),
    CREEPER(Type.MOB, "v1_7_R3", CreeperDisguise.class, "EntityCreeper", "creeper"),
    DONKEY(Type.MOB, "v1_7_R3", ChestedHorseDisguise.class, "EntityHorseDonkey", "donkey"),
    ELDER_GUARDIAN(Type.MOB, "v1_8_R1", MobDisguise.class, "EntityGuardianElder", "elder_guardian"),
    ENDER_DRAGON(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityEnderDragon", "ender_dragon", "dragon", "ender-dragon", "enderdragon"),
    ENDERMAN(Type.MOB, "v1_7_R3", EndermanDisguise.class, "EntityEnderman", "enderman", "endermen"),
    ENDERMITE(Type.MOB, "v1_8_R1", MobDisguise.class, "EntityEndermite", "endermite", "mite"),
    EVOKER(Type.MOB, "v1_11_R1", MobDisguise.class, "EntityEvoker", "evoker"),
    GHAST(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityGhast", "ghast"),
    GIANT(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityGiantZombie", "giant", "giant_zombie", "giant-zombie", "giantzombie"),
    GUARDIAN(Type.MOB, "v1_8_R1", MobDisguise.class, "EntityGuardian", "guardian"),
    HORSE(Type.MOB, "v1_7_R3", StyledHorseDisguise.class, "EntityHorse", "horse"),
    HUSK(Type.MOB, "v1_10_R1", AgeableDisguise.class, "EntityZombieHusk", "husk"),
    IRON_GOLEM(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityIronGolem", "iron_golem", "iron-golem", "irongolem", "golem"),
    LLAMA(Type.MOB, "v1_11_R1", LlamaDisguise.class, "EntityLlama", "llama"),
    MAGMA_CUBE(Type.MOB, "v1_7_R3", SizedDisguise.class, "EntityMagmaCube", "magma_cube", "magma-cube", "magmacube", "magma", "lava_cube", "lava-cube", "lavacube", "lava", "magma_slime", "magma-slime", "magmaslime", "lava_slime", "lava-slime", "lavaslime"),
    MULE(Type.MOB, "v1_7_R3", ChestedHorseDisguise.class, "EntityHorseMule", "mule"),
    MUSHROOM_COW(Type.MOB, "v1_7_R3", AgeableDisguise.class, "EntityMushroomCow", "mushroom_cow", "mushroom-cow", "mushroomcow", "mushroom", "mooshroom"),
    OCELOT(Type.MOB, "v1_7_R3", OcelotDisguise.class, "EntityOcelot", "ocelot", "cat"),
    PIG(Type.MOB, "v1_7_R3", PigDisguise.class, "EntityPig", "pig"),
    PIG_ZOMBIE(Type.MOB, "v1_7_R3", AgeableDisguise.class, "EntityPigZombie", "pig_zombie", "pig-zombie", "pigzombie", "pigman", "zombie_pigman", "zombie-pigman", "zombiepigman"),
    POLAR_BEAR(Type.MOB, "v1_10_R1", AgeableDisguise.class, "EntityPolarBear", "polar_bear", "polar-bear", "polarbear", "bear"),
    RABBIT(Type.MOB, "v1_8_R1", RabbitDisguise.class, "EntityRabbit", "rabbit", "bunny"),
    SHEEP(Type.MOB, "v1_7_R3", SheepDisguise.class, "EntitySheep", "sheep"),
    SHULKER(Type.MOB, "v1_9_R1", MobDisguise.class, "EntityShulker", "shulker"),
    SILVERFISH(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySilverfish", "silverfish"),
    SKELETAL_HORSE(Type.MOB, "v1_7_R3", HorseDisguise.class, "EntityHorseSkeleton", "skeletal_horse"),
    SKELETON(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySkeleton", "skeleton"),
    SLIME(Type.MOB, "v1_7_R3", SizedDisguise.class, "EntitySlime", "slime", "cube"),
    SNOWMAN(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySnowman", "snowman", "snow-man", "snow_man", "snow_golem", "snow-golem", "snowgolem"),
    SPIDER(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySpider", "spider"),
    SQUID(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySquid", "squid"),
    STRAY(Type.MOB, "v1_10_R1", MobDisguise.class, "EntitySkeletonStray", "stray"),
    UNDEAD_HORSE(Type.MOB, "v1_7_R3", HorseDisguise.class, "EntityHorseZombie", "undead_horse"),
    VEX(Type.MOB, "v1_11_R1", MobDisguise.class, "EntityVex", "vex"),
    VILLAGER(Type.MOB, "v1_7_R3", VillagerDisguise.class, "EntityVillager", "villager"),
    VINDICATOR(Type.MOB, "v1_11_R1", MobDisguise.class, "EntityVindicator", "vindicator"),
    WITCH(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityWitch", "witch"),
    WITHER(Type.MOB, "v1_7_R3", MobDisguise.class, "EntityWither", "wither", "witherboss", "wither-boss", "wither_boss"),
    WITHER_SKELETON(Type.MOB, "v1_7_R3", MobDisguise.class, "EntitySkeletonWither", "wither_skeleton"),
    WOLF(Type.MOB, "v1_7_R3", WolfDisguise.class, "EntityWolf", "wolf", "dog"),
    ZOMBIE(Type.MOB, "v1_7_R3", AgeableDisguise.class, "EntityZombie", "zombie"),
    ZOMBIE_VILLAGER(Type.MOB, "v1_7_R3", ZombieVillagerDisguise.class, "EntityZombieVillager", "zombie_villager", "infected_villager"),
    GHOST(Type.PLAYER, "v1_7_R3", PlayerDisguise.class, "EntityPlayer", new String[0]),
    PLAYER(Type.PLAYER, "v1_7_R3", PlayerDisguise.class, "EntityPlayer", new String[0]),
    ARMOR_STAND(Type.OBJECT, "v1_8_R1", ArmorStandDisguise.class, "EntityArmorStand", "armor_stand", "armor-stand", "armorstand"),
    BOAT(Type.OBJECT, "v1_7_R3", ObjectDisguise.class, "EntityBoat", "boat"),
    ENDER_CRYSTAL(Type.OBJECT, "v1_7_R3", ObjectDisguise.class, "EntityEnderCrystal", "ender_crystal", "ender-crystal", "endercrystal", "crystal"),
    FALLING_BLOCK(Type.OBJECT, "v1_7_R3", FallingBlockDisguise.class, "EntityFallingBlock", "falling_block", "falling-block", "fallingblock", "block"),
    ITEM(Type.OBJECT, "v1_7_R3", ItemDisguise.class, "EntityItem", "item", "itemstack", "item-stack", "item_stack"),
    MINECART(Type.OBJECT, "v1_7_R3", MinecartDisguise.class, "EntityMinecartRideable", "minecart", "cart");

    private final Type type;
    private final String requiredVersion;
    private final Class<? extends Disguise> disguiseClass;
    private final String nmsClass;
    private final String commandArgument;
    private static final Random random;

    static {
        random = new Random();
    }

    private DisguiseType(Type type, String requiredVersion, Class<? extends Disguise> disguiseClass, String nmsClass, String ... commandArgs) {
        this.type = type;
        this.requiredVersion = requiredVersion;
        this.disguiseClass = disguiseClass;
        this.nmsClass = nmsClass;
        if (commandArgs != null) {
            this.commandArgument = commandArgs.length > 0 ? commandArgs[0] : null;
            String[] stringArray = commandArgs;
            int n2 = commandArgs.length;
            int n3 = 0;
            while (n3 < n2) {
                String argument = stringArray[n3];
                if (!Matcher.matcher.containsKey(argument)) {
                    Matcher.matcher.put(argument, this);
                }
                ++n3;
            }
        } else {
            this.commandArgument = null;
        }
    }

    public boolean isMob() {
        return this.type == Type.MOB;
    }

    public boolean isPlayer() {
        return this.type == Type.PLAYER;
    }

    public boolean isObject() {
        return this.type == Type.OBJECT;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isAvailable() {
        return VersionHelper.requireVersion(this.requiredVersion);
    }

    public Class<? extends Disguise> getDisguiseClass() {
        return this.disguiseClass;
    }

    public Disguise newInstance() {
        if (!this.isAvailable()) {
            throw new OutdatedServerException();
        }
        try {
            return this.disguiseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return this.disguiseClass.getDeclaredConstructor(DisguiseType.class).newInstance(new Object[]{this});
            }
            catch (NoSuchMethodException e2) {
                throw new UnsupportedOperationException();
            }
            catch (Exception e2) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getNMSClass() {
        return this.nmsClass;
    }

    public String getDefaultCommandArgument() {
        return this.commandArgument;
    }

    public String toString() {
        if (this.getDefaultCommandArgument() != null) {
            return this.getDefaultCommandArgument();
        }
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static DisguiseType random(Type type) {
        ArrayList<DisguiseType> types = new ArrayList<DisguiseType>(Arrays.asList(DisguiseType.values()));
        if (type != null) {
            int pos = 0;
            while (pos < types.size()) {
                if (((DisguiseType)((Object)types.get(pos))).getType() != type || !((DisguiseType)((Object)types.get(pos))).isAvailable()) {
                    types.remove(pos);
                    continue;
                }
                ++pos;
            }
        }
        DisguiseType randomType = (DisguiseType)((Object)types.get(random.nextInt(types.size())));
        return randomType;
    }

    public static class Matcher {
        private static final Map<String, DisguiseType> matcher = new ConcurrentHashMap<String, DisguiseType>();

        public static DisguiseType match(String string) {
            return matcher.get(string.toLowerCase(Locale.ENGLISH));
        }
    }

    public static enum Type {
        MOB,
        PLAYER,
        OBJECT;

    }
}

