/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.disguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.OutdatedServerException;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.disguise.Subtypes;
import de.robingrether.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.entity.Player;

public abstract class Disguise
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3699593353745149494L;
    protected final DisguiseType type;
    private Visibility visibility = Visibility.EVERYONE;
    private final List<String> visibilityParameter = new ArrayList<String>();

    static {
        Subtypes.registerParameterizedSubtype(Disguise.class, "setVisibility", "visibility", Visibility.class);
        Subtypes.registerParameterizedSubtype(Disguise.class, "setVisibilityParameter", "visibility-param", String[].class);
    }

    protected Disguise(DisguiseType type) {
        if (!type.isAvailable()) {
            throw new OutdatedServerException();
        }
        this.type = type;
    }

    public DisguiseType getType() {
        return this.type;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
        this.visibilityParameter.clear();
    }

    public String[] getVisibilityParameter() {
        return this.visibilityParameter.toArray(new String[0]);
    }

    public void setVisibilityParameter(String ... visibilityParameter) {
        this.visibilityParameter.clear();
        String[] stringArray = visibilityParameter;
        int n = visibilityParameter.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            this.visibilityParameter.add(parameter.toLowerCase(Locale.ENGLISH));
            ++n2;
        }
    }

    public boolean isVisibleTo(Player player) {
        switch (this.visibility) {
            case EVERYONE: {
                return true;
            }
            case ONLY_LIST: {
                return this.visibilityParameter.contains(player.getName().toLowerCase(Locale.ENGLISH));
            }
            case NOT_LIST: {
                return !this.visibilityParameter.contains(player.getName().toLowerCase(Locale.ENGLISH));
            }
            case ONLY_PERMISSION: {
                return player.hasPermission(this.visibilityParameter.get(0));
            }
            case NOT_PERMISSION: {
                return !player.hasPermission(this.visibilityParameter.get(0));
            }
        }
        return false;
    }

    public final Disguise clone() {
        return Disguise.fromString(this.toString());
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.type.toString()) + "; visibility=" + this.visibility.name().toLowerCase(Locale.ENGLISH) + "; visibility-param=" + String.join((CharSequence)",", this.visibilityParameter.toArray(new String[0]));
    }

    public static Disguise fromString(String string) throws IllegalArgumentException, OutdatedServerException {
        String[] args = string.split("; ");
        DisguiseType type = DisguiseType.Matcher.match(args[0]);
        if (type == null) {
            if (StringUtil.equals((String)args[0], (String[])new String[]{"player", "ghost"}) && args.length == 5) {
                PlayerDisguise disguise = new PlayerDisguise(args[3], args[4], args[0].equals("ghost"));
                Subtypes.applySubtype(disguise, args[1]);
                Subtypes.applySubtype(disguise, args[2]);
                return disguise;
            }
        } else {
            Disguise disguise = type.newInstance();
            int i = 1;
            while (i < args.length) {
                Subtypes.applySubtype(disguise, args[i]);
                ++i;
            }
            return disguise;
        }
        throw new IllegalArgumentException();
    }

    public static enum Visibility {
        EVERYONE,
        ONLY_LIST,
        NOT_LIST,
        ONLY_PERMISSION,
        NOT_PERMISSION;

    }
}

