/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise;

import de.robingrether.idisguise.disguise.DisguiseType;
import de.robingrether.idisguise.disguise.MobDisguise;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.iDisguise;
import de.robingrether.idisguise.io.UpdateCheck;
import de.robingrether.idisguise.management.ChannelInjector;
import de.robingrether.idisguise.management.DisguiseManager;
import de.robingrether.idisguise.management.GhostFactory;
import de.robingrether.idisguise.management.PlayerHelper;
import de.robingrether.util.StringUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class EventListener
implements Listener {
    private iDisguise plugin;
    private Map<UUID, Long> mapLastMessageSent = new ConcurrentHashMap<UUID, Long>();

    public EventListener(iDisguise plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!this.plugin.enabled()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "Server start/reload has not finished yet");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        ChannelInjector.getInstance().inject(player);
        PlayerHelper.getInstance().addPlayer(player);
        PlayerHelper.getInstance().loadGameProfileAsynchronously(player.getName());
        GhostFactory.getInstance().addPlayer(player.getName());
        if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise && ((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).isGhost()) {
            if (this.plugin.getConfiguration().ENABLE_GHOST_DISGUISE) {
                GhostFactory.getInstance().addPlayer(((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).getSkinName());
                GhostFactory.getInstance().addGhost(player);
            } else {
                DisguiseManager.getInstance().undisguise((OfflinePlayer)player);
                player.sendMessage(this.plugin.getLanguage().UNDISGUISE_GHOST_DISABLED);
            }
        }
        if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
            player.sendMessage(this.plugin.getLanguage().JOIN_DISGUISED);
        }
        if (this.plugin.getConfiguration().MODIFY_MESSAGE_JOIN && event.getJoinMessage() != null && DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise) {
                event.setJoinMessage(event.getJoinMessage().replace(player.getName(), ((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).getDisplayName()));
            } else {
                event.setJoinMessage(null);
            }
        }
        if (player.hasPermission("iDisguise.update") && this.plugin.getConfiguration().UPDATE_CHECK) {
            this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)new UpdateCheck(this.plugin, (CommandSender)player, this.plugin.getConfiguration().UPDATE_DOWNLOAD), 20L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfiguration().MODIFY_MESSAGE_LEAVE && event.getQuitMessage() != null && DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
            if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise) {
                event.setQuitMessage(event.getQuitMessage().replace(player.getName(), ((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).getDisplayName()));
            } else {
                event.setQuitMessage(null);
            }
        }
        if (!this.plugin.getConfiguration().KEEP_DISGUISE_LEAVE && DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
            DisguiseManager.getInstance().undisguise((OfflinePlayer)player);
        }
        ChannelInjector.getInstance().remove(player);
        GhostFactory.getInstance().removeGhost(player);
        PlayerHelper.getInstance().removePlayer(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getDeathMessage() != null) {
            Player player = event.getEntity();
            if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)player)) {
                if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)player) instanceof PlayerDisguise) {
                    event.setDeathMessage(event.getDeathMessage().replaceAll("(" + player.getDisplayName() + "|" + player.getName() + ")", ((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)player)).getDisplayName()));
                } else {
                    event.setDeathMessage(null);
                    return;
                }
            }
            if (player.getLastDamageCause() instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)player.getLastDamageCause()).getDamager() instanceof Player) {
                Player killer = (Player)((EntityDamageByEntityEvent)player.getLastDamageCause()).getDamager();
                if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)killer)) {
                    if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)killer) instanceof PlayerDisguise) {
                        event.setDeathMessage(event.getDeathMessage().replaceAll("(" + killer.getDisplayName() + "|" + killer.getName() + ")", ((PlayerDisguise)DisguiseManager.getInstance().getDisguise((OfflinePlayer)killer)).getDisplayName()));
                    } else if (DisguiseManager.getInstance().getDisguise((OfflinePlayer)killer) instanceof MobDisguise) {
                        event.setDeathMessage(event.getDeathMessage().replaceAll("(" + killer.getDisplayName() + "|" + killer.getName() + ")", StringUtil.capitalizeFully((String)DisguiseManager.getInstance().getDisguise((OfflinePlayer)killer).getType().name().replace('_', ' '))));
                    } else {
                        event.setDeathMessage(null);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (DisguiseManager.getInstance().isDisguised((OfflinePlayer)player) && DisguiseManager.getInstance().getDisguise((OfflinePlayer)player).getType().equals((Object)DisguiseType.SHULKER)) {
            long lastSent;
            event.setCancelled(true);
            long l = lastSent = this.mapLastMessageSent.containsKey(player.getUniqueId()) ? this.mapLastMessageSent.get(player.getUniqueId()) : 0L;
            if (lastSent + 3000L < System.currentTimeMillis()) {
                player.sendMessage(this.plugin.getLanguage().MOVE_AS_SHULKER);
                this.mapLastMessageSent.put(player.getUniqueId(), System.currentTimeMillis());
            }
        }
    }
}

