/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.additions;

import de.robingrether.idisguise.additions.Additions;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class Language {
    public String UNDISGUISE_PVP = ChatColor.GOLD + "You were undisguised because PvP is not allowed while you are disguised.";
    public String UNDISGUISE_PVE = ChatColor.GOLD + "You were undisguised because PvE is not allowed while you are disguised.";
    public String UNDISGUISE_PROJECTILE = ChatColor.GOLD + "You were undisguised because you were hit by a projectile.";
    private Additions plugin;

    public Language(Additions plugin) {
        this.plugin = plugin;
    }

    public void loadData() {
        File languageFile = new File(this.plugin.getDataFolder(), "language.yml");
        YamlConfiguration fileConfiguration = YamlConfiguration.loadConfiguration((File)languageFile);
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.getType().equals(String.class) || !fileConfiguration.isString(field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-'))) continue;
                field.set(this, fileConfiguration.getString(field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-')));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occured while loading the language file.", e);
        }
    }

    public void saveData() {
        File languageFile = new File(this.plugin.getDataFolder(), "language.yml");
        YamlConfiguration fileConfiguration = new YamlConfiguration();
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.getType().equals(String.class)) continue;
                fileConfiguration.set(field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-'), field.get(this));
            }
            fileConfiguration.save(languageFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "An error occured while saving the language file.", e);
        }
    }
}

