/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.additions;

import de.robingrether.idisguise.additions.Additions;
import de.robingrether.idisguise.api.DisguiseAPI;
import de.robingrether.idisguise.api.DisguiseEvent;
import de.robingrether.idisguise.api.UndisguiseEvent;
import de.robingrether.idisguise.disguise.PlayerDisguise;
import de.robingrether.idisguise.iDisguise;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class EventListenerLegacy
implements Listener {
    private Additions plugin;
    private DisguiseAPI api;

    public EventListenerLegacy(Additions plugin) {
        this.plugin = plugin;
        this.api = iDisguise.getInstance().getAPI();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        if (event.getTarget() instanceof Player) {
            Player target = (Player)event.getTarget();
            if (this.plugin.getConfiguration().DISABLE_MOB_TARGET && this.api.isDisguised((OfflinePlayer)target)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity damagee = event.getEntity();
        Entity damager = event.getDamager();
        if (damagee instanceof Player && damager instanceof Player) {
            if (this.plugin.getConfiguration().UNDISGUISE_PVP) {
                if (this.api.isDisguisedTo((OfflinePlayer)((Player)damagee), (Player)damager)) {
                    this.api.undisguise((OfflinePlayer)((Player)damagee), false);
                    ((Player)damagee).sendMessage(this.plugin.getLanguage().UNDISGUISE_PVP);
                }
                if (this.api.isDisguisedTo((OfflinePlayer)((Player)damager), (Player)damagee)) {
                    this.api.undisguise((OfflinePlayer)((Player)damager), false);
                    ((Player)damager).sendMessage(this.plugin.getLanguage().UNDISGUISE_PVP);
                }
            }
        } else if (damagee instanceof Player) {
            if (this.api.isDisguised((OfflinePlayer)damagee)) {
                if (this.plugin.getConfiguration().DISABLE_MOB_DAMAGE) {
                    event.setCancelled(true);
                } else {
                    if (this.plugin.getConfiguration().UNDISGUISE_PVE) {
                        this.api.undisguise((OfflinePlayer)((Player)damagee), false);
                        ((Player)damagee).sendMessage(this.plugin.getLanguage().UNDISGUISE_PVE);
                    }
                    if (this.plugin.getConfiguration().UNDISGUISE_PROJECTILE && damager instanceof Projectile) {
                        this.api.undisguise((OfflinePlayer)((Player)damagee), false);
                        ((Player)damagee).sendMessage(this.plugin.getLanguage().UNDISGUISE_PROJECTILE);
                    }
                }
            }
        } else if (damager instanceof Player && this.plugin.getConfiguration().UNDISGUISE_PVE && this.api.isDisguised((OfflinePlayer)damager)) {
            this.api.undisguise((OfflinePlayer)((Player)damager), false);
            ((Player)damager).sendMessage(this.plugin.getLanguage().UNDISGUISE_PVE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityPickupItem(PlayerPickupItemEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (this.plugin.getConfiguration().DISABLE_ITEM_PICK_UP && this.api.isDisguised((OfflinePlayer)event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisguise(DisguiseEvent event) {
        if (this.plugin.getConfiguration().MODIFY_DISPLAY_NAME && event.getDisguise() instanceof PlayerDisguise) {
            event.getPlayer().setDisplayName(((PlayerDisguise)event.getDisguise()).getDisplayName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUndisguise(UndisguiseEvent event) {
        if (this.plugin.getConfiguration().MODIFY_DISPLAY_NAME && event.getDisguise() instanceof PlayerDisguise) {
            event.getPlayer().setDisplayName(event.getPlayer().getName());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.plugin.getConfiguration().MODIFY_DISPLAY_NAME && this.api.getDisguise((OfflinePlayer)event.getPlayer()) instanceof PlayerDisguise) {
            event.getPlayer().setDisplayName(event.getPlayer().getName());
        }
    }
}

