/*
 * Decompiled with CFR 0.152.
 */
package de.robingrether.idisguise.additions;

import de.robingrether.idisguise.additions.Configuration;
import de.robingrether.idisguise.additions.EventListener;
import de.robingrether.idisguise.additions.EventListenerLegacy;
import de.robingrether.idisguise.additions.Language;
import de.robingrether.idisguise.io.bstats.Metrics;
import de.robingrether.idisguise.management.VersionHelper;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Additions
extends JavaPlugin {
    private Listener listener;
    private Configuration configuration;
    private Language language;
    private Metrics metrics;

    public void onEnable() {
        this.checkDirectory();
        this.listener = VersionHelper.require1_12() ? new EventListener(this) : new EventListenerLegacy(this);
        this.configuration = new Configuration(this);
        this.configuration.loadData();
        this.configuration.saveData();
        this.language = new Language(this);
        this.language.loadData();
        this.language.saveData();
        this.metrics = new Metrics((JavaPlugin)this);
        this.getServer().getPluginManager().registerEvents(this.listener, (Plugin)this);
        this.getLogger().log(Level.INFO, String.format("%s enabled!", this.getFullName()));
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, String.format("%s disabled!", this.getFullName()));
    }

    public void onReload() {
        this.configuration.loadData();
        this.configuration.saveData();
        this.language.loadData();
        this.language.saveData();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("idisguiseadditions")) {
            if (sender instanceof ConsoleCommandSender || sender instanceof Player && ((Player)sender).hasPermission("iDisguiseAdditions.reload")) {
                this.onReload();
                sender.sendMessage(ChatColor.GOLD + "Reloaded config file.");
            } else {
                sender.sendMessage(ChatColor.RED + "You are not allowed to do this.");
            }
        }
        return true;
    }

    private void checkDirectory() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public String getFullName() {
        return "iDisguiseAdditions " + this.getVersion();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Language getLanguage() {
        return this.language;
    }
}

